/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.jsp.rule.design;

import java.util.Locale;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.jsp.ast.ASTAttribute;
import net.sourceforge.pmd.lang.jsp.ast.ASTElement;
import net.sourceforge.pmd.lang.jsp.rule.AbstractJspRule;
import net.sourceforge.pmd.util.CollectionUtil;

public class NoInlineStyleInformationRule
extends AbstractJspRule {
    private static final Set<String> STYLE_ELEMENT_NAMES = CollectionUtil.setOf((Object)"B", (Object[])new String[]{"I", "FONT", "BASEFONT", "U", "CENTER"});
    private static final Set<String> ELEMENT_NAMES_THAT_CAN_HAVE_STYLE_ATTRIBUTES = CollectionUtil.setOf((Object)"P", (Object[])new String[]{"TABLE", "THEAD", "TBODY", "TFOOT", "TR", "TD", "COL", "COLGROUP"});
    private static final Set<String> STYLE_ATTRIBUTES = CollectionUtil.setOf((Object)"STYLE", (Object[])new String[]{"FONT", "SIZE", "COLOR", "FACE", "ALIGN", "VALIGN", "BGCOLOR"});

    @Override
    public Object visit(ASTAttribute node, Object data) {
        if (this.isStyleAttribute(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTElement node, Object data) {
        if (this.isStyleElement(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return super.visit(node, data);
    }

    private boolean isStyleElement(ASTElement elementNode) {
        return STYLE_ELEMENT_NAMES.contains(elementNode.getName().toUpperCase(Locale.ROOT));
    }

    private boolean isStyleAttribute(ASTAttribute attributeNode) {
        ASTElement parent;
        return STYLE_ATTRIBUTES.contains(attributeNode.getName().toUpperCase(Locale.ROOT)) && attributeNode.getParent() instanceof ASTElement && ELEMENT_NAMES_THAT_CAN_HAVE_STYLE_ATTRIBUTES.contains((parent = (ASTElement)attributeNode.getParent()).getName().toUpperCase(Locale.ROOT));
    }
}

