/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.PmdXPathException;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.lang.rule.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonXPathRuleQuery;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathRule
extends AbstractRule {
    private static final Logger LOG = LoggerFactory.getLogger(XPathRule.class);
    @Deprecated
    public static final PropertyDescriptor<String> XPATH_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"xpath").desc("XPath expression")).defaultValue((Object)"")).build();
    private SaxonXPathRuleQuery xpathRuleQuery;
    private DeprecatedAttrLogger attrLogger = DeprecatedAttrLogger.create((XPathRule)this);

    @Deprecated
    public XPathRule() {
        this.definePropertyDescriptor(XPATH_DESCRIPTOR);
    }

    public XPathRule(XPathVersion version, String expression) {
        this();
        Objects.requireNonNull(version, "XPath version is null");
        Objects.requireNonNull(expression, "XPath expression is null");
        this.setProperty(XPATH_DESCRIPTOR, expression);
    }

    public Rule deepCopy() {
        XPathRule rule = (XPathRule)((Object)super.deepCopy());
        rule.attrLogger = this.attrLogger;
        return rule;
    }

    public String getXPathExpression() {
        return (String)this.getProperty(XPATH_DESCRIPTOR);
    }

    public void apply(Node target, RuleContext ctx) {
        List nodesWithViolation;
        SaxonXPathRuleQuery query = this.getQueryMaybeInitialize();
        try {
            nodesWithViolation = query.evaluate(target);
        }
        catch (PmdXPathException e) {
            throw this.addExceptionContext(e);
        }
        for (Node nodeWithViolation : nodesWithViolation) {
            String messageArg = nodeWithViolation.getImage();
            if (messageArg == null) {
                messageArg = this.getFirstMessageArgFromNode(nodeWithViolation, "Name", "SimpleName", "MethodName");
            }
            ctx.addViolation(nodeWithViolation, new Object[]{messageArg});
        }
    }

    private String getFirstMessageArgFromNode(Node node, String ... attributeNames) {
        List<String> nameList = Arrays.asList(attributeNames);
        return IteratorUtil.toStream((Iterator)node.getXPathAttributesIterator()).filter(a -> nameList.contains(a.getName())).findFirst().map(Attribute::getStringValue).orElse(null);
    }

    private ContextedRuntimeException addExceptionContext(PmdXPathException e) {
        return e.addRuleName(this.getName());
    }

    public void initialize(LanguageProcessor languageProcessor) {
        String xpath = this.getXPathExpression();
        XPathVersion version = XPathVersion.DEFAULT;
        try {
            this.xpathRuleQuery = new SaxonXPathRuleQuery(xpath, version, this.getPropertiesByPropertyDescriptor(), languageProcessor.services().getXPathHandler(), this.attrLogger);
        }
        catch (PmdXPathException e) {
            throw this.addExceptionContext(e);
        }
    }

    private SaxonXPathRuleQuery getQueryMaybeInitialize() throws PmdXPathException {
        if (this.xpathRuleQuery == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.xpathRuleQuery;
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        List visits = this.getQueryMaybeInitialize().getRuleChainVisits();
        this.logXPathRuleChainUsage(!visits.isEmpty());
        return visits.isEmpty() ? RuleTargetSelector.forRootOnly() : RuleTargetSelector.forXPathNames((Collection)visits);
    }

    private void logXPathRuleChainUsage(boolean usesRuleChain) {
        LOG.debug("{} rule chain for XPath rule: {} ({})", new Object[]{usesRuleChain ? "Using" : "no", this.getName(), this.getRuleSetName()});
    }

    public String dysfunctionReason() {
        if (StringUtils.isBlank((CharSequence)this.getXPathExpression())) {
            return "Missing XPath expression";
        }
        return null;
    }
}

