/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.RendererHelper;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLRenderer
implements CPDReportRenderer,
CPDRenderer {
    private String encoding;

    public XMLRenderer() {
        this(null);
    }

    public XMLRenderer(String encoding) {
        this.setEncoding(encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding != null ? encoding : System.getProperty("file.encoding");
    }

    public String getEncoding() {
        return this.encoding;
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            return parser.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private void dumpDocToWriter(Document doc, Writer writer) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("version", "1.0");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.encoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("cdata-section-elements", "codefragment");
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public void render(CPDReport report, Writer writer) throws IOException {
        Document doc = this.createDocument();
        Element root = doc.createElement("pmd-cpd");
        Map numberOfTokensPerFile = report.getNumberOfTokensPerFile();
        doc.appendChild(root);
        for (Map.Entry pair : numberOfTokensPerFile.entrySet()) {
            Element fileElement = doc.createElement("file");
            fileElement.setAttribute("path", report.getDisplayName((FileId)pair.getKey()));
            fileElement.setAttribute("totalNumberOfTokens", String.valueOf(pair.getValue()));
            root.appendChild(fileElement);
        }
        for (Match match : report.getMatches()) {
            Element dupElt = this.createDuplicationElement(doc, match);
            this.addFilesToDuplicationElement(doc, dupElt, match, report);
            this.addCodeSnippet(doc, dupElt, match, report);
            root.appendChild(dupElt);
        }
        this.dumpDocToWriter(doc, writer);
        writer.flush();
    }

    private void addFilesToDuplicationElement(Document doc, Element duplication, Match match, CPDReport report) {
        for (Mark mark : match) {
            Element file = doc.createElement("file");
            FileLocation loc = mark.getLocation();
            file.setAttribute("line", String.valueOf(loc.getStartLine()));
            String filenameXml10 = StringUtil.removedInvalidXml10Characters((String)report.getDisplayName(loc.getFileId()));
            file.setAttribute("path", filenameXml10);
            file.setAttribute("endline", String.valueOf(loc.getEndLine()));
            file.setAttribute("column", String.valueOf(loc.getStartColumn()));
            file.setAttribute("endcolumn", String.valueOf(loc.getEndColumn()));
            file.setAttribute("begintoken", String.valueOf(mark.getBeginTokenIndex()));
            file.setAttribute("endtoken", String.valueOf(mark.getEndTokenIndex()));
            duplication.appendChild(file);
        }
    }

    private void addCodeSnippet(Document doc, Element duplication, Match match, CPDReport report) {
        Chars codeSnippet = report.getSourceCodeSlice(match.getFirstMark());
        if (codeSnippet != null) {
            String platformSpecific = codeSnippet.toString().replace("\n", System.lineSeparator());
            Element codefragment = doc.createElement("codefragment");
            codefragment.appendChild(doc.createCDATASection(StringUtil.removedInvalidXml10Characters((String)platformSpecific)));
            duplication.appendChild(codefragment);
        }
    }

    private Element createDuplicationElement(Document doc, Match match) {
        Element duplication = doc.createElement("duplication");
        duplication.setAttribute("lines", String.valueOf(match.getLineCount()));
        duplication.setAttribute("tokens", String.valueOf(match.getTokenCount()));
        return duplication;
    }

    @Override
    public void render(Iterator<Match> matches, Writer writer) throws IOException {
        RendererHelper.render(matches, writer, this);
    }
}

