/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Properties;
import java.util.stream.Collectors;
import net.sourceforge.pmd.cpd.AbstractLanguage;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public final class LanguageFactory {
    private LanguageFactory() {
    }

    public static Language createLanguage(String name, Properties properties) {
        CpdCapableLanguage cpdLanguage = (CpdCapableLanguage)LanguageRegistry.CPD.getLanguageById(name);
        if (cpdLanguage != null) {
            return new CpdLanguageAdapter(cpdLanguage, properties);
        }
        throw new UnsupportedOperationException("Language " + name + " is not supported");
    }

    public static class CpdLanguageAdapter
    extends AbstractLanguage {
        private CpdCapableLanguage language;

        public CpdLanguageAdapter(CpdCapableLanguage cpdCapableLanguage, Properties properties) {
            super(cpdCapableLanguage.getName(), cpdCapableLanguage.getId(), CpdLanguageAdapter.createLexer(cpdCapableLanguage, properties), CpdLanguageAdapter.convertExtensions(cpdCapableLanguage));
            this.language = cpdCapableLanguage;
        }

        private static Tokenizer createLexer(CpdCapableLanguage cpdCapableLanguage, Properties properties) {
            LanguagePropertyBundle propertyBundle = cpdCapableLanguage.newPropertyBundle();
            for (String propName : properties.stringPropertyNames()) {
                PropertyDescriptor propertyDescriptor = propertyBundle.getPropertyDescriptor(propName);
                if (propertyDescriptor == null) continue;
                CpdLanguageAdapter.setProperty(propertyBundle, propertyDescriptor, properties.getProperty(propName));
            }
            CpdLexer cpdLexer = cpdCapableLanguage.createCpdLexer(propertyBundle);
            return (arg_0, arg_1) -> ((CpdLexer)cpdLexer).tokenize(arg_0, arg_1);
        }

        private static <T> void setProperty(LanguagePropertyBundle propertyBundle, PropertyDescriptor<T> propertyDescriptor, String stringValue) {
            Object value = propertyDescriptor.serializer().fromString(stringValue);
            propertyBundle.setProperty(propertyDescriptor, value);
        }

        private static String[] convertExtensions(CpdCapableLanguage cpdCapableLanguage) {
            return cpdCapableLanguage.getExtensions().stream().map(s -> "." + s).collect(Collectors.toList()).toArray(new String[0]);
        }

        public CpdCapableLanguage getLanguage() {
            return this.language;
        }
    }
}

