package net.kemitix.spring;

import java.io.IOException;
import org.springframework.core.io.Resource;

/**
 * Interface for reading a {@link Resource}.
 *
 * @since 1.0.0-RELEASE
 * @author Paul Campbell (pcampbell@kemitix.net)
 */
public interface ResourceReader {

    /**
     * Reads the {@link Resource} into a String.
     *
     * @param resource the {@link Resource} to read
     * @return the contents of the {@link Resource}
     * @throws IOException if Resource is not found or can't be opened or read
     */
    String read(Resource resource) throws IOException;

}
