/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagTypeRegister;
import java.util.List;

public abstract class TagType {
    private final String description;
    private final String startDelimiter;
    private final char[] startDelimiterCharArray;
    private final String closingDelimiter;
    private final boolean isServerTag;
    private final String namePrefix;

    TagType(String description, String startDelimiter, String closingDelimiter, boolean isServerTag, String startDelimiterPrefix) {
        this.description = description;
        this.startDelimiter = startDelimiter;
        this.startDelimiterCharArray = startDelimiter.toCharArray();
        this.closingDelimiter = closingDelimiter;
        this.isServerTag = isServerTag;
        this.namePrefix = startDelimiter.substring(startDelimiterPrefix.length());
    }

    public final void register() {
        TagTypeRegister.add(this);
    }

    public final void deregister() {
        TagTypeRegister.remove(this);
    }

    public static final List getRegisteredTagTypes() {
        return TagTypeRegister.getList();
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getStartDelimiter() {
        return this.startDelimiter;
    }

    public final String getClosingDelimiter() {
        return this.closingDelimiter;
    }

    public final boolean isServerTag() {
        return this.isServerTag;
    }

    protected final String getNamePrefix() {
        return this.namePrefix;
    }

    protected boolean isValidPosition(Source source, int pos) {
        if (this.isServerTag()) {
            return true;
        }
        TagType[] tagTypesIgnoringEnclosedMarkup = TagType.getTagTypesIgnoringEnclosedMarkup();
        for (int i = 0; i < tagTypesIgnoringEnclosedMarkup.length; ++i) {
            if (!tagTypesIgnoringEnclosedMarkup[i].tagEncloses(source, pos)) continue;
            return false;
        }
        return true;
    }

    public static final TagType[] getTagTypesIgnoringEnclosedMarkup() {
        return TagTypesIgnoringEnclosedMarkup.array;
    }

    public static final void setTagTypesIgnoringEnclosedMarkup(TagType[] tagTypes) {
        if (tagTypes == null) {
            throw new IllegalArgumentException();
        }
        TagTypesIgnoringEnclosedMarkup.array = tagTypes;
    }

    protected abstract Tag constructTagAt(Source var1, int var2);

    protected final boolean tagEncloses(Source source, int pos) {
        if (pos == 0) {
            return false;
        }
        Tag enclosingTag = source.findEnclosingTag(pos - 1, this);
        return enclosingTag != null && pos != enclosingTag.getEnd();
    }

    public String toString() {
        return this.getDescription();
    }

    static final Tag getTagAt(Source source, int pos) {
        TagTypeRegister.ProspectiveTagTypeIterator prospectiveTagTypeIterator = new TagTypeRegister.ProspectiveTagTypeIterator(source, pos);
        while (prospectiveTagTypeIterator.hasNext()) {
            TagType tagType = prospectiveTagTypeIterator.getNextTagType();
            if (!tagType.isValidPosition(source, pos)) continue;
            try {
                Tag tag = tagType.constructTagAt(source, pos);
                if (tag == null) continue;
                return tag;
            }
            catch (IndexOutOfBoundsException ex) {
                source.log("Tag", null, pos, "not recognised as type '", tagType.getDescription(), "' because it has no end delimiter", -1);
            }
        }
        return null;
    }

    final String getNamePrefixForTagConstant() {
        return this.getNamePrefix();
    }

    final char[] getStartDelimiterCharArray() {
        return this.startDelimiterCharArray;
    }

    private static final class TagTypesIgnoringEnclosedMarkup {
        public static TagType[] array = new TagType[]{StartTagType.COMMENT, StartTagType.CDATA_SECTION};

        private TagTypesIgnoringEnclosedMarkup() {
        }
    }
}

