/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Segment
implements Comparable,
CharSequence {
    final int begin;
    final int end;
    final Source source;
    private static final char[] WHITESPACE = new char[]{' ', '\n', '\r', '\t', '\f', '\u200b'};

    public Segment(Source source, int begin, int end) {
        if (begin == -1 || end == -1 || begin > end) {
            throw new IllegalArgumentException();
        }
        this.begin = begin;
        this.end = end;
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int length) {
        this.begin = 0;
        this.end = length;
        this.source = (Source)this;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    public final int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int pos) {
        return this.begin <= pos && pos < this.end;
    }

    public String toString() {
        return ((Object)this.source.text.subSequence(this.begin, this.end)).toString();
    }

    public String extractText() {
        Tag tag;
        StringBuffer sb = new StringBuffer(this.length());
        int textBegin = this.begin;
        while ((tag = this.source.findNextTag(textBegin)) != null && tag.begin < this.end) {
            int textEnd = tag.begin;
            while (textBegin < textEnd) {
                sb.append(this.source.charAt(textBegin++));
            }
            textBegin = tag.end;
        }
        while (textBegin < this.end) {
            sb.append(this.source.charAt(textBegin++));
        }
        String decodedText = CharacterReference.decodeCollapseWhiteSpace(sb);
        return decodedText;
    }

    public List findAllTags() {
        return this.findAllTags(null);
    }

    public List findAllTags(TagType tagType) {
        Tag tag = this.checkEnclosure(Tag.findPreviousOrNextTag(this.source, this.begin, tagType, false));
        if (tag == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        do {
            list.add(tag);
        } while ((tag = this.checkEnclosure(Tag.findPreviousOrNextTag(this.source, tag.begin + 1, tagType, false))) != null);
        return list;
    }

    public List findAllStartTags() {
        return this.findAllStartTags(null);
    }

    public List findAllStartTags(String name) {
        StartTag startTag;
        if (name != null) {
            name = name.toLowerCase();
        }
        if ((startTag = (StartTag)this.checkEnclosure(StartTag.findPreviousOrNext(this.source, this.begin, name, false))) == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(StartTag.findPreviousOrNext(this.source, startTag.begin + 1, name, false))) != null);
        return list;
    }

    public List findAllStartTags(String attributeName, String value, boolean valueCaseSensitive) {
        StartTag startTag = (StartTag)this.checkEnclosure(this.source.findNextStartTag(this.begin, attributeName, value, valueCaseSensitive));
        if (startTag == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(this.source.findNextStartTag(startTag.begin + 1, attributeName, value, valueCaseSensitive))) != null);
        return list;
    }

    public List findAllElements() {
        return this.findAllElements((String)null);
    }

    public List findAllElements(String name) {
        List startTags;
        if (name != null) {
            name = name.toLowerCase();
        }
        if ((startTags = this.findAllStartTags(name)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> elements = new ArrayList<Element>(startTags.size());
        Iterator i = startTags.iterator();
        while (i.hasNext()) {
            StartTag startTag = (StartTag)i.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            elements.add(element);
        }
        return elements;
    }

    public List findAllElements(StartTagType startTagType) {
        List startTags = this.findAllTags(startTagType);
        if (startTags.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> elements = new ArrayList<Element>(startTags.size());
        Iterator i = startTags.iterator();
        while (i.hasNext()) {
            StartTag startTag = (StartTag)i.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            elements.add(element);
        }
        return elements;
    }

    public List findAllCharacterReferences() {
        CharacterReference characterReference = this.findNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CharacterReference> list = new ArrayList<CharacterReference>();
        do {
            list.add(characterReference);
        } while ((characterReference = this.findNextCharacterReference(characterReference.end)) != null);
        return list;
    }

    public List findFormControls() {
        return FormControl.findAll(this);
    }

    public FormFields findFormFields() {
        return new FormFields(this.findFormControls());
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        Segment segment = (Segment)o;
        if (this.begin < segment.begin) {
            return -1;
        }
        if (this.begin > segment.begin) {
            return 1;
        }
        if (this.end < segment.end) {
            return -1;
        }
        if (this.end > segment.end) {
            return 1;
        }
        return 0;
    }

    public final boolean isWhiteSpace() {
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhiteSpace(char ch) {
        for (int i = 0; i < WHITESPACE.length; ++i) {
            if (ch != WHITESPACE[i]) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer(50);
        sb.append('(');
        this.source.getRowColumnVector(this.begin).appendTo(sb);
        sb.append('-');
        this.source.getRowColumnVector(this.end).appendTo(sb);
        sb.append(')');
        return sb.toString();
    }

    public char charAt(int index) {
        return this.source.toString().charAt(this.begin + index);
    }

    public final CharSequence subSequence(int beginIndex, int endIndex) {
        return this.source.text.subSequence(this.begin + beginIndex, this.begin + endIndex);
    }

    public boolean isComment() {
        return false;
    }

    public List findAllComments() {
        return this.findAllTags(StartTagType.COMMENT);
    }

    public String getSourceText() {
        return this.toString();
    }

    public final String getSourceTextNoWhitespace() {
        return Segment.appendCollapseWhiteSpace(new StringBuffer(this.length()), this).toString();
    }

    public final List findWords() {
        ArrayList<Segment> words = new ArrayList<Segment>();
        int wordBegin = -1;
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.charAt(i))) {
                if (wordBegin == -1) continue;
                words.add(new Segment(this.source, wordBegin, i));
                wordBegin = -1;
                continue;
            }
            if (wordBegin != -1) continue;
            wordBegin = i;
        }
        if (wordBegin != -1) {
            words.add(new Segment(this.source, wordBegin, this.end));
        }
        return words;
    }

    static final StringBuffer appendCollapseWhiteSpace(StringBuffer sb, CharSequence text) {
        int i = 0;
        boolean lastWasWhiteSpace = true;
        boolean isWhiteSpace = false;
        while (i < text.length()) {
            char ch;
            if (isWhiteSpace = Segment.isWhiteSpace(ch = text.charAt(i++))) {
                if (!lastWasWhiteSpace) {
                    sb.append(' ');
                }
            } else {
                sb.append(ch);
            }
            lastWasWhiteSpace = isWhiteSpace;
        }
        if (isWhiteSpace && sb.length() != 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    private Tag checkEnclosure(Tag tag) {
        if (tag == null || tag.end > this.end) {
            return null;
        }
        return tag;
    }

    private CharacterReference findNextCharacterReference(int pos) {
        CharacterReference characterReference = this.source.findNextCharacterReference(pos);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

