/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterEntityReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.NumericCharacterReference;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Util;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    static final int MAX_CODE_POINT = 0x10FFFF;
    private static final int TAB_LENGTH = 4;

    CharacterReference(Source source, int begin, int end, int codePoint) {
        super(source, begin, end);
        this.codePoint = codePoint;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public boolean isTerminated() {
        return this.source.charAt(this.end - 1) == ';';
    }

    public static String encode(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(unencodedText.length() * 2), unencodedText, false).toString();
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(unencodedText.length() * 2), unencodedText, true).toString();
    }

    public static String decode(CharSequence encodedText) {
        return CharacterReference.decode(encodedText, false);
    }

    public static String decode(CharSequence encodedText, boolean insideAttributeValue) {
        if (encodedText == null) {
            return null;
        }
        String encodedString = ((Object)encodedText).toString();
        int pos = encodedString.indexOf(38);
        if (pos == -1) {
            return encodedString;
        }
        return CharacterReference.appendDecode(new StringBuffer(encodedString.length()), encodedString, pos, insideAttributeValue).toString();
    }

    public static String decodeCollapseWhiteSpace(CharSequence text) {
        return CharacterReference.decode(Segment.appendCollapseWhiteSpace(new StringBuffer(text.length()), text));
    }

    public static String reencode(CharSequence encodedText) {
        return CharacterReference.encode(CharacterReference.decode(encodedText, true));
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int codePoint) {
        String characterReferenceString = null;
        if (codePoint != 39) {
            characterReferenceString = CharacterEntityReference.getCharacterReferenceString(codePoint);
        }
        if (characterReferenceString == null) {
            characterReferenceString = NumericCharacterReference.getCharacterReferenceString(codePoint);
        }
        return characterReferenceString;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int codePoint) {
        return CharacterReference.appendDecimalCharacterReferenceString(new StringBuffer(), codePoint).toString();
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int codePoint) {
        return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuffer(), codePoint).toString();
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int codePoint) {
        return CharacterReference.appendUnicodeText(new StringBuffer(), codePoint).toString();
    }

    static final StringBuffer appendUnicodeText(StringBuffer sb, int codePoint) {
        sb.append("U+");
        String hex = Integer.toString(codePoint, 16).toUpperCase();
        for (int i = 4 - hex.length(); i > 0; --i) {
            sb.append('0');
        }
        sb.append(hex);
        return sb;
    }

    public static CharacterReference parse(CharSequence characterReferenceText) {
        return CharacterReference.construct(new Source(((Object)characterReferenceText).toString()), 0, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence characterReferenceText) {
        CharacterReference characterReference = CharacterReference.parse(characterReferenceText);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char ch) {
        return ch > '\u007f' || CharacterEntityReference.getName(ch) != null && (ch != '\'' || Config.IsApostropheEncoded);
    }

    static StringBuffer appendEncode(StringBuffer sb, CharSequence unencodedText, boolean whiteSpaceFormatting) {
        if (unencodedText == null) {
            return sb;
        }
        int beginPos = 0;
        int endPos = unencodedText.length();
        if (unencodedText instanceof Segment) {
            int segmentOffset;
            Segment segment = (Segment)unencodedText;
            beginPos = segmentOffset = segment.getBegin();
            endPos += segmentOffset;
            unencodedText = segment.source.toString();
        }
        boolean isApostropheEncoded = Config.IsApostropheEncoded;
        for (int i = beginPos; i < endPos; ++i) {
            int spaceCount;
            char ch = unencodedText.charAt(i);
            String characterEntityReferenceName = CharacterEntityReference.getName(ch);
            if (characterEntityReferenceName != null) {
                if (ch == '\'') {
                    if (isApostropheEncoded) {
                        sb.append("&#39;");
                        continue;
                    }
                    sb.append(ch);
                    continue;
                }
                CharacterEntityReference.appendCharacterReferenceString(sb, characterEntityReferenceName);
                continue;
            }
            if (ch > '\u007f') {
                CharacterReference.appendDecimalCharacterReferenceString(sb, ch);
                continue;
            }
            if (!whiteSpaceFormatting || !Segment.isWhiteSpace(ch)) {
                sb.append(ch);
                continue;
            }
            int nexti = i + 1;
            if (ch != ' ') {
                if (ch != '\t') {
                    if (ch == '\r' && nexti < endPos && unencodedText.charAt(nexti) == '\n') {
                        ++i;
                    }
                    sb.append("<br />");
                    continue;
                }
                spaceCount = 4;
            } else {
                spaceCount = 1;
            }
            while (nexti < endPos) {
                ch = unencodedText.charAt(nexti);
                if (ch == ' ') {
                    ++spaceCount;
                } else {
                    if (ch != '\t') break;
                    spaceCount += 4;
                }
                ++nexti;
            }
            if (spaceCount == 1) {
                sb.append(' ');
                continue;
            }
            if (spaceCount % 2 == 1) {
                sb.append(' ');
            }
            while (spaceCount >= 2) {
                sb.append("&nbsp; ");
                spaceCount -= 2;
            }
            i = nexti - 1;
        }
        return sb;
    }

    static CharacterReference findPreviousOrNext(Source source, int pos, boolean previous) {
        return CharacterReference.findPreviousOrNext(source, pos, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL, previous);
    }

    private static CharacterReference findPreviousOrNext(Source source, int pos, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings, boolean previous) {
        ParseText parseText = source.getParseText();
        int n = pos = previous ? parseText.lastIndexOf('&', pos) : parseText.indexOf('&', pos);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            pos = previous ? parseText.lastIndexOf('&', pos - 1) : parseText.indexOf('&', pos + 1);
        }
        return null;
    }

    static final StringBuffer appendHexadecimalCharacterReferenceString(StringBuffer sb, int codePoint) {
        return sb.append("&#x").append(Integer.toString(codePoint, 16)).append(';');
    }

    static final StringBuffer appendDecimalCharacterReferenceString(StringBuffer sb, int codePoint) {
        return sb.append("&#").append(codePoint).append(';');
    }

    private static CharacterReference construct(Source source, int begin, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        try {
            if (source.getParseText().charAt(begin) != '&') {
                return null;
            }
            return source.getParseText().charAt(begin + 1) == '#' ? NumericCharacterReference.construct(source, begin, unterminatedCharacterReferenceSettings) : CharacterEntityReference.construct(source, begin, unterminatedCharacterReferenceSettings.characterEntityReferenceMaxCodePoint);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private static StringBuffer appendDecode(StringBuffer sb, String encodedString, int pos, boolean insideAttributeValue) {
        CharacterReference characterReference;
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(insideAttributeValue);
        int lastEnd = 0;
        Source source = new Source(encodedString);
        while ((characterReference = CharacterReference.findPreviousOrNext(source, pos, unterminatedCharacterReferenceSettings, false)) != null) {
            if (lastEnd != characterReference.getBegin()) {
                Util.appendTo(sb, (CharSequence)encodedString, lastEnd, characterReference.getBegin());
            }
            sb.append((char)characterReference.codePoint);
            pos = lastEnd = characterReference.getEnd();
        }
        if (lastEnd != encodedString.length()) {
            Util.appendTo(sb, (CharSequence)encodedString, lastEnd, encodedString.length());
        }
        return sb;
    }
}

