/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.FormFields;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public final class Util {
    private static final int BUFFER_SIZE = 1024;
    private static final String CSVNewLine = System.getProperty("line.separator");

    private Util() {
    }

    public static String getString(Reader reader) throws IOException {
        int n;
        if (reader == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(reader, 1024);
        char[] cArray = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read(cArray, 0, 1024)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void outputCSVLine(Writer writer, String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                if (string == FormFields.ColumnTrue || string == FormFields.ColumnFalse) {
                    writer.write(string);
                } else {
                    writer.write(34);
                    Util.outputValueEscapeQuotes(writer, string);
                    writer.write(34);
                }
            }
            if (++n == stringArray.length) continue;
            writer.write(44);
        }
        writer.write(CSVNewLine);
    }

    private static void outputValueEscapeQuotes(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            writer.write(c);
            if (c != '\"') continue;
            writer.write(c);
        }
    }

    static StringBuffer appendTo(StringBuffer stringBuffer, CharSequence charSequence) {
        return Util.appendTo(stringBuffer, charSequence, 0, charSequence.length());
    }

    static StringBuffer appendTo(StringBuffer stringBuffer, CharSequence charSequence, int n, int n2) {
        while (n < n2) {
            stringBuffer.append(charSequence.charAt(n));
            ++n;
        }
        return stringBuffer;
    }

    static Writer appendTo(Writer writer, CharSequence charSequence) throws IOException {
        return Util.appendTo(writer, charSequence, 0, charSequence.length());
    }

    static Writer appendTo(Writer writer, CharSequence charSequence, int n, int n2) throws IOException {
        while (n < n2) {
            writer.write(charSequence.charAt(n));
            ++n;
        }
        return writer;
    }
}

