set version=1.5-dev1
set package_name=jericho-html-%version%

md bin
md lib

rem ----- Compile source:
javac -d bin src\au\id\jericho\lib\html\*.java src\au\id\jericho\lib\html\internal\*.java
if errorlevel 1 goto end

rem ----- Create jar library:
jar -cf lib\%package_name%.jar -C bin au

@if "%1"=="-nojavadoc" goto buildsamples
rem ----- Create docs:
javadoc -quiet -public -windowtitle "Jericho HTML Parser %version%" -classpath src;bin -d doc\api au.id.jericho.lib.html
echo samp {font-family: sans-serif; font-size: 20px} >> doc\api\stylesheet.css

rem ----- Build the samples:
:buildsamples
md samples\bin
javac -deprecation -classpath lib/%package_name%.jar -d samples\bin samples\src\*.java
if errorlevel 1 goto end
md samples\bat_lib
echo @set package_name=%package_name%> samples\bat_lib\set_package_name.bat

@if "%1"=="-nojavadoc" goto end
rem ----- Zip up the whole package:
jar -cMf ..\%package_name%.zip -C .. %package_name%

:end

