/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import io.grpc.Server;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import net.devh.boot.grpc.server.serverfactory.GrpcServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class GrpcServerLifecycle
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerLifecycle.class);
    private static AtomicInteger serverCounter = new AtomicInteger(-1);
    private volatile Server server;
    private volatile int phase = Integer.MAX_VALUE;
    private final GrpcServerFactory factory;

    public GrpcServerLifecycle(GrpcServerFactory factory) {
        this.factory = factory;
    }

    public void start() {
        try {
            this.createAndStartGrpcServer();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to start the grpc server", e);
        }
    }

    public void stop() {
        this.stopAndReleaseGrpcServer();
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.server != null && !this.server.isShutdown();
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return true;
    }

    protected void createAndStartGrpcServer() throws IOException {
        Server localServer = this.server;
        if (localServer == null) {
            this.server = this.factory.createServer();
            this.server.start();
            log.info("gRPC Server started, listening on address: " + this.factory.getAddress() + ", port: " + this.factory.getPort());
            Thread awaitThread = new Thread("container-" + serverCounter.incrementAndGet()){

                @Override
                public void run() {
                    try {
                        GrpcServerLifecycle.this.server.awaitTermination();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            awaitThread.setDaemon(false);
            awaitThread.start();
        }
    }

    protected void stopAndReleaseGrpcServer() {
        this.factory.destroy();
        Server localServer = this.server;
        if (localServer != null) {
            localServer.shutdown();
            this.server = null;
            log.info("gRPC server shutdown.");
        }
    }
}

