/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.interceptors;

import io.grpc.Context;
import io.grpc.ForwardingServerCallListener;
import io.grpc.ServerCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticatingServerCallListener<ReqT>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthenticatingServerCallListener.class);
    private final Context context;

    protected AbstractAuthenticatingServerCallListener(ServerCall.Listener<ReqT> delegate, Context context) {
        super(delegate);
        this.context = context;
    }

    protected final Context context() {
        return this.context;
    }

    protected abstract void attachAuthenticationContext();

    protected abstract void detachAuthenticationContext();

    public void onMessage(ReqT message) {
        Context previous = this.context.attach();
        try {
            this.attachAuthenticationContext();
            log.debug("onMessage - Authentication set");
            super.onMessage(message);
        }
        finally {
            this.detachAuthenticationContext();
            this.context.detach(previous);
            log.debug("onMessage - Authentication cleared");
        }
    }

    public void onHalfClose() {
        Context previous = this.context.attach();
        try {
            this.attachAuthenticationContext();
            log.debug("onHalfClose - Authentication set");
            super.onHalfClose();
        }
        finally {
            this.detachAuthenticationContext();
            this.context.detach(previous);
            log.debug("onHalfClose - Authentication cleared");
        }
    }

    public void onCancel() {
        Context previous = this.context.attach();
        try {
            this.attachAuthenticationContext();
            log.debug("onCancel - Authentication set");
            super.onCancel();
        }
        finally {
            this.detachAuthenticationContext();
            log.debug("onCancel - Authentication cleared");
            this.context.detach(previous);
        }
    }

    public void onComplete() {
        Context previous = this.context.attach();
        try {
            this.attachAuthenticationContext();
            log.debug("onComplete - Authentication set");
            super.onComplete();
        }
        finally {
            this.detachAuthenticationContext();
            log.debug("onComplete - Authentication cleared");
            this.context.detach(previous);
        }
    }

    public void onReady() {
        Context previous = this.context.attach();
        try {
            this.attachAuthenticationContext();
            log.debug("onReady - Authentication set");
            super.onReady();
        }
        finally {
            this.detachAuthenticationContext();
            log.debug("onReady - Authentication cleared");
            this.context.detach(previous);
        }
    }
}

