/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.authentication;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.util.Collection;
import java.util.Objects;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

public class AnonymousAuthenticationReader
implements GrpcAuthenticationReader {
    private static final Logger log = LoggerFactory.getLogger(AnonymousAuthenticationReader.class);
    private final String key;
    private final Object principal;
    private final Collection<? extends GrantedAuthority> authorities;

    public AnonymousAuthenticationReader(String key) {
        this(key, "anonymousUser", AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    }

    public AnonymousAuthenticationReader(String key, Object principal, Collection<? extends GrantedAuthority> authorities) {
        this.key = Objects.requireNonNull(key, "key");
        this.principal = Objects.requireNonNull(principal, "principal");
        this.authorities = Objects.requireNonNull(authorities, "authorities");
    }

    @Override
    public Authentication readAuthentication(ServerCall<?, ?> call, Metadata headers) {
        log.debug("Continue with anonymous auth");
        return new AnonymousAuthenticationToken(this.key, this.principal, this.authorities);
    }
}

