/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.interceptor;

import com.google.common.collect.Maps;
import io.grpc.ServerInterceptor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.devh.boot.grpc.server.interceptor.GlobalServerInterceptorConfigurer;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AnnotationGlobalServerInterceptorConfigurer
implements GlobalServerInterceptorConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationGlobalServerInterceptorConfigurer.class);
    private final ApplicationContext applicationContext;

    public AnnotationGlobalServerInterceptorConfigurer(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "applicationContext");
    }

    protected Map<String, ServerInterceptor> getServerInterceptorBeans() {
        return Maps.transformValues((Map)this.applicationContext.getBeansWithAnnotation(GrpcGlobalServerInterceptor.class), ServerInterceptor.class::cast);
    }

    @Override
    public void configureServerInterceptors(List<ServerInterceptor> interceptors) {
        for (Map.Entry<String, ServerInterceptor> entry : this.getServerInterceptorBeans().entrySet()) {
            ServerInterceptor interceptor = entry.getValue();
            log.debug("Registering GlobalServerInterceptor: {} ({})", (Object)entry.getKey(), (Object)interceptor);
            interceptors.add(interceptor);
        }
    }
}

