/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.common.autoconfigure;

import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import net.devh.boot.grpc.common.codec.AnnotationGrpcCodecDiscoverer;
import net.devh.boot.grpc.common.codec.GrpcCodecDefinition;
import net.devh.boot.grpc.common.codec.GrpcCodecDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Codec.class})
public class GrpcCommonCodecAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcCommonCodecAutoConfiguration.class);

    @ConditionalOnMissingBean
    @Bean
    public GrpcCodecDiscoverer defaultGrpcCodecDiscoverer() {
        return new AnnotationGrpcCodecDiscoverer();
    }

    @ConditionalOnBean(value={GrpcCodecDiscoverer.class})
    @ConditionalOnMissingBean
    @Bean
    public CompressorRegistry defaultCompressorRegistry(GrpcCodecDiscoverer codecDiscoverer) {
        log.debug("Found GrpcCodecDiscoverer -> Creating custom CompressorRegistry");
        CompressorRegistry registry = CompressorRegistry.getDefaultInstance();
        for (GrpcCodecDefinition definition : codecDiscoverer.findGrpcCodecs()) {
            if (!definition.getCodecType().isForCompression()) continue;
            Codec codec = definition.getCodec();
            log.debug("Registering compressor: '{}' ({})", (Object)codec.getMessageEncoding(), (Object)codec.getClass().getName());
            registry.register((Compressor)codec);
        }
        return registry;
    }

    @ConditionalOnBean(value={GrpcCodecDiscoverer.class})
    @ConditionalOnMissingBean
    @Bean
    public DecompressorRegistry defaultDecompressorRegistry(GrpcCodecDiscoverer codecDiscoverer) {
        log.debug("Found GrpcCodecDiscoverer -> Creating custom DecompressorRegistry");
        DecompressorRegistry registry = DecompressorRegistry.getDefaultInstance();
        for (GrpcCodecDefinition definition : codecDiscoverer.findGrpcCodecs()) {
            if (!definition.getCodecType().isForDecompression()) continue;
            Codec codec = definition.getCodec();
            boolean isAdvertised = definition.isAdvertised();
            log.debug("Registering {} decompressor: '{}' ({})", new Object[]{isAdvertised ? "advertised" : "", codec.getMessageEncoding(), codec.getClass().getName()});
            registry = registry.with((Decompressor)codec, isAdvertised);
        }
        return registry;
    }
}

