/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import com.google.common.collect.ImmutableMap;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelFactory;
import net.devh.boot.grpc.client.channelfactory.InProcessChannelFactory;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;

public class InProcessOrAlternativeChannelFactory
implements GrpcChannelFactory {
    private static final String IN_PROCESS_SCHEME = "in-process";
    private final GrpcChannelsProperties properties;
    private final InProcessChannelFactory inProcessChannelFactory;
    private final GrpcChannelFactory alternativeChannelFactory;

    public InProcessOrAlternativeChannelFactory(GrpcChannelsProperties properties, InProcessChannelFactory inProcessChannelFactory, GrpcChannelFactory alternativeChannelFactory) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.inProcessChannelFactory = Objects.requireNonNull(inProcessChannelFactory, "inProcessChannelFactory");
        this.alternativeChannelFactory = Objects.requireNonNull(alternativeChannelFactory, "alternativeChannelFactory");
    }

    @Override
    public Channel createChannel(String name, List<ClientInterceptor> interceptors, boolean sortInterceptors) {
        URI address = this.properties.getChannel(name).getAddress();
        if (address != null && IN_PROCESS_SCHEME.equals(address.getScheme())) {
            return this.inProcessChannelFactory.createChannel(address.getSchemeSpecificPart(), interceptors, sortInterceptors);
        }
        return this.alternativeChannelFactory.createChannel(name, interceptors, sortInterceptors);
    }

    @Override
    public Map<String, ConnectivityState> getConnectivityState() {
        return ImmutableMap.builder().putAll(this.inProcessChannelFactory.getConnectivityState()).putAll(this.alternativeChannelFactory.getConnectivityState()).build();
    }

    @Override
    public void close() {
        try {
            this.inProcessChannelFactory.close();
        }
        finally {
            this.alternativeChannelFactory.close();
        }
    }
}

