/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.proxy;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.subethamail.smtp.internal.proxy.ProxyHandler;
import org.subethamail.smtp.internal.util.ArrayUtils;
import org.subethamail.smtp.internal.util.HexUtils;
import org.subethamail.smtp.server.Session;

public class ProxyProtocolV2Handler
implements ProxyHandler {
    private static final Logger log = Logger.getLogger(ProxyProtocolV2Handler.class.getName());
    private static final int DEFAULT_MAX_DATA_LENGTH = 2048;
    public static final ProxyProtocolV2Handler INSTANCE = new ProxyProtocolV2Handler();
    private static final byte[] PROXY_MAGIC = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final int PROXY_HEADER_SIZE = 16;
    private static final int BYTE_HIGH_4_BITS_SHIFT = 4;
    private static final int BYTE_LOW_4_BITS = 15;
    private static final int IPV4_LEN = 4;
    private static final int IPV6_LEN = 16;
    private final int maxDataLength;

    private ProxyProtocolV2Handler() {
        this(2048);
    }

    public ProxyProtocolV2Handler(int maxDataLength) {
        this.maxDataLength = maxDataLength;
    }

    static int prefixSize() {
        return PROXY_MAGIC.length;
    }

    boolean isValidPrefix(byte[] prefix) {
        return prefix.length >= PROXY_MAGIC.length && ArrayUtils.equals(PROXY_MAGIC, 0, PROXY_MAGIC.length, prefix, 0, PROXY_MAGIC.length);
    }

    @Override
    public ProxyHandler.ProxyResult handle(InputStream in, OutputStream out, Session session) throws IOException {
        InetSocketAddress clientAddress;
        Transport transport;
        Family family;
        Command command;
        int versionAndCommand;
        int versionbin;
        log.log(Level.FINE, "(session {0}) Starting PROXY protocol v2 handling", session.getSessionId());
        byte[] header = new byte[16];
        int read = in.read(header);
        if (read != 16) {
            String headerHex = HexUtils.toHex(header, 0, read);
            log.log(Level.SEVERE, "(session {0}) Failed to fully read PROXY v2 header. Read {1}", new Object[]{session.getSessionId(), headerHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        String headerHex = HexUtils.toHex(header);
        log.log(Level.FINE, "(session {0}) Read header {1}", new Object[]{session.getSessionId(), headerHex});
        if (!ArrayUtils.equals(PROXY_MAGIC, 0, PROXY_MAGIC.length, header, 0, PROXY_MAGIC.length)) {
            String receivedMagic = HexUtils.toHex(header, 0, PROXY_MAGIC.length);
            log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v2 magic {1} (header: {2})", new Object[]{session.getSessionId(), receivedMagic, headerHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        int idx = PROXY_MAGIC.length;
        if ((versionbin = (versionAndCommand = Byte.toUnsignedInt(header[idx++])) >> 4) != 2) {
            log.log(Level.SEVERE, "(session {0}) Usupported PROXY protocol version {1} (header: {2})", new Object[]{session.getSessionId(), versionbin, headerHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        int commandbin = versionAndCommand & 0xF;
        switch (commandbin) {
            case 0: {
                command = Command.LOCAL;
                break;
            }
            case 1: {
                command = Command.PROXY;
                break;
            }
            default: {
                log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v2 command {1} (header: {2})", new Object[]{session.getSessionId(), commandbin, headerHex});
                return ProxyHandler.ProxyResult.FAIL;
            }
        }
        int familyAndTransport = Byte.toUnsignedInt(header[idx++]);
        int familybin = familyAndTransport >> 4;
        switch (familybin) {
            case 0: {
                family = Family.UNSPEC;
                break;
            }
            case 1: {
                family = Family.INET;
                break;
            }
            case 2: {
                family = Family.INET6;
                break;
            }
            case 3: {
                family = Family.UNIX;
                break;
            }
            default: {
                log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v2 family {1} (header: {2})", new Object[]{session.getSessionId(), familybin, headerHex});
                return ProxyHandler.ProxyResult.FAIL;
            }
        }
        int transportbin = familyAndTransport & 0xF;
        switch (transportbin) {
            case 0: {
                transport = Transport.UNSPEC;
                break;
            }
            case 1: {
                transport = Transport.STREAM;
                break;
            }
            case 2: {
                transport = Transport.DGRAM;
                break;
            }
            default: {
                log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v2 transport {1} (header: {2})", new Object[]{session.getSessionId(), transportbin, headerHex});
                return ProxyHandler.ProxyResult.FAIL;
            }
        }
        int len = (header[idx++] << 8 | header[idx++]) & 0xFFFF;
        if (len > this.maxDataLength) {
            log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v2 length {1} greater than configured maximum length {2} (header: {3})", new Object[]{session.getSessionId(), len, this.maxDataLength, headerHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        byte[] data = new byte[len];
        read = ProxyProtocolV2Handler.readNBytes(in, data, 0, len);
        if (read != len) {
            String dataHex = HexUtils.toHex(data, 0, read);
            log.log(Level.SEVERE, "(session {0}) Failed to fully read PROXY v2 data, EOF reached. Read {1}", new Object[]{session.getSessionId(), dataHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        if (command == Command.LOCAL) {
            return ProxyHandler.ProxyResult.NOP;
        }
        switch (family) {
            case UNIX: {
                log.log(Level.WARNING, "(session {0}) unsupported PROXY protocol v2 family UNIX, falling back to UNSPEC", session.getSessionId());
            }
            case UNSPEC: {
                return ProxyHandler.ProxyResult.NOP;
            }
            case INET: {
                InetAddress ip;
                byte[] raw = new byte[4];
                System.arraycopy(data, 0, raw, 0, 4);
                try {
                    ip = InetAddress.getByAddress(raw);
                }
                catch (UnknownHostException ex) {
                    String rawHex = HexUtils.toHex(raw, ':');
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v2 source IPv4 {1}", new Object[]{session.getSessionId(), rawHex});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                int port = (data[8] & 0xFF) << 8 | data[9] & 0xFF;
                clientAddress = new InetSocketAddress(ip, port);
                break;
            }
            case INET6: {
                InetAddress ip;
                byte[] raw = new byte[16];
                System.arraycopy(data, 0, raw, 0, 16);
                try {
                    ip = InetAddress.getByAddress(raw);
                }
                catch (UnknownHostException ex) {
                    String rawHex = HexUtils.toHex(raw, ':');
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v2 source IPv6 {1}", new Object[]{session.getSessionId(), rawHex});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                int port = (data[16] & 0xFF) << 8 | data[17] & 0xFF;
                clientAddress = new InetSocketAddress(ip, port);
                break;
            }
            default: {
                log.log(Level.SEVERE, "(session {0}) Unknown PROXY protocol v2 address family {1}", new Object[]{session.getSessionId(), family});
                return ProxyHandler.ProxyResult.FAIL;
            }
        }
        log.log(Level.FINE, "(session {0}) Accepted PROXY connection: command {1} family {2} transport {3} client {4} original {5}", new Object[]{session.getSessionId(), command, family, transport, clientAddress.getHostString(), session.getRealRemoteAddress().getHostString()});
        return new ProxyHandler.ProxyResult(clientAddress);
    }

    private static int readNBytes(InputStream is, byte[] data, int offset, int len) throws IOException {
        int read;
        Preconditions.checkArgument(len >= 0);
        Preconditions.checkArgument(offset >= 0);
        Preconditions.checkArgument(offset + len <= data.length);
        int start = offset;
        while (len > 0 && (read = is.read(data, offset, len)) > 0) {
            offset += read;
            len -= read;
        }
        return offset - start;
    }

    public static enum Transport {
        UNSPEC(0),
        STREAM(1),
        DGRAM(2);

        public final int value;

        private Transport(int value) {
            this.value = value;
        }
    }

    public static enum Family {
        UNSPEC(0),
        INET(1),
        INET6(2),
        UNIX(3);

        public final int value;

        private Family(int value) {
            this.value = value;
        }
    }

    public static enum Command {
        LOCAL(0),
        PROXY(1);

        public final int value;

        private Command(int value) {
            this.value = value;
        }
    }
}

