package com.appspress.component.properties.repository.storage

import kotlinx.coroutines.Deferred
import kotlinx.coroutines.Job

/**
 * Contract for storages
 */
interface IStorage {

  /**
   * Get property by [key].
   */
  fun getPropertyAsync(key: String): Deferred<String?>

  /**
   * Set property [value] by [key].
   */
  fun setPropertyAsync(key: String, value: String): Job?

  /**
   * Delete property from storage by [key]
   */
  fun deletePropertyAsync(key: String): Job?

}