package com.appspress.component.properties.repository.storage

/**
 * Log memory storage
 */
interface IMemoryStorageLogger {

  /**
   * Log exception [e] when memory storage fails to store [key] with [value]
   */
  fun failedToSetMemoryStorageValue(e: Throwable, key: String, value: String)

  /**
   * Log exception [e] when memory storage fails to store [key] with [value]
   */
  fun failedToSetMemoryListStorageValue(e: Throwable, key: String, value: List<String>)

  /**
   * Log exception [e] when memory storage fails to delete [key]
   */
  fun failedToDeleteMemoryStorageValue(e: Throwable, key: String)

  /**
   * Log exception [e] when memory storage fails to delete [key]
   */
  fun failedToDeleteMemoryListStorageValue(e: Throwable, key: String)

}
