package com.appspress.component.properties.repository.storage

import java.io.File

/**
 * Internal storage logger
 */
interface IInternalStorageLogger {

  /**
   * Logs exception [e] when internal storage fails to retrieve property data by [propertyName] from file [destinationFile].
   */
  fun failedToRetrieveDataFromFile(e: Exception, destinationFile: File, propertyName: String)

  /**
   * Logs exception [e] when internal storage fails to construct file object for file [filename].
   */
  fun filedToCreateFileObjectByName(e: Exception, filename: String)

  /**
   * Logs exception [e] when internal storage fails to construct file object for file [filename].
   */
  fun failedToCreateListPropertyFileObjectByName(e: Exception, filename: String)

  /**
   * Logs exception [e] when internal storage fails to write property to file.
   */
  fun failedToWritePropertyValueToFile(e: Exception, key: String, value: String)

  /**
   * Logs exception [e] when internal storage fails to delete property
   */
  fun failedToDeleteProperty(e: Exception, key: String)

  fun failedToCreateListElementPropertyFileObject(e: Exception)

}
