package com.appspress.component.properties.repository

import com.appspress.component.properties.model.PropertyListModel
import kotlinx.coroutines.Deferred
import kotlinx.coroutines.Job

/**
 * Properties storage repository
 */
interface IPropertiesRepository {

  /**
   * Puts property in local storage
   */
  fun putToLocal(property: String, value: String): Job?

  /**
   * Retrieves property from local storage
   */
  fun getFromLocalAsync(property: String): Deferred<String?>

  /**
   * Deletes property from local storage
   */
  fun deleteFromLocal(property: String): Job?

  /**
   * Puts property in memory storage
   */
  fun putToMemory(property: String, value: String): Job?

  /**
   * Retrieves property from memory storage
   */
  fun getFromMemoryAsync(property: String): Deferred<String?>

  /**
   * Deletes property from memory storage
   */
  fun deleteFromMemory(property: String): Job?

  /**
   * Puts property in Internal storage
   */
  fun putToInternal(property: String, value: String): Job?

  /**
   * Retrieves property from Internal storage
   */
  fun getFromInternalAsync(property: String): Deferred<String?>

  /**
   * Deletes property from Internal storage
   */
  fun deleteFromInternal(property: String): Job?

//  fun getListFromMemoryAsync(key: String): Deferred<List<String>?>
//  fun putListToMemoryAsync(key: String, list: List<String>) : Job?
//  fun appendListToMemoryAsync(key: String, value: List<String>): Job?
//  fun clearMemoryListAsync(key: String): Job?


  fun getListFromInternalAsync(key: String): Deferred<PropertyListModel?>
  fun putListToInternalAsync(key: String, list: List<String>) : Job?
  fun appendListToInternalAsync(key: String, value: List<String>): Job?
  fun clearInternalListAsync(key: String): Job?
  fun clearInternalListAsync(key: String, value: PropertyListModel): Job?
  fun clearInternalListAsync(key: String, recordsToKeep: Int): Job?

}