/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.model;

import java.io.Serializable;
import org.codehaus.metaclass.model.Attribute;

public abstract class FeatureDescriptor
implements Serializable {
    private final Attribute[] m_declaredAttributes;
    private final Attribute[] m_attributes;

    protected FeatureDescriptor(Attribute[] declaredAttributes, Attribute[] attributes) {
        int i;
        if (null == declaredAttributes) {
            throw new NullPointerException("declaredAttributes");
        }
        if (null == attributes) {
            throw new NullPointerException("attributes");
        }
        for (i = 0; i < declaredAttributes.length; ++i) {
            if (null != declaredAttributes[i]) continue;
            throw new NullPointerException("declaredAttributes[" + i + "]");
        }
        for (i = 0; i < attributes.length; ++i) {
            if (null != attributes[i]) continue;
            throw new NullPointerException("attributes[" + i + "]");
        }
        for (i = 0; i < declaredAttributes.length; ++i) {
            Attribute attribute = declaredAttributes[i];
            boolean match = false;
            for (int j = 0; j < attributes.length; ++j) {
                Attribute other = attributes[j];
                if (!attribute.equals(other)) continue;
                match = true;
                break;
            }
            if (match) continue;
            String message = "declaredAttribute[" + i + "] not an attribute";
            throw new IllegalArgumentException(message);
        }
        this.m_declaredAttributes = declaredAttributes;
        this.m_attributes = attributes;
    }

    public Attribute[] getDeclaredAttributes() {
        return this.m_declaredAttributes;
    }

    public Attribute[] getAttributes() {
        return this.m_attributes;
    }
}

