/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.metaclass.io;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.codehaus.metaclass.model.Attribute;
import org.codehaus.metaclass.model.ClassDescriptor;
import org.codehaus.metaclass.model.FieldDescriptor;
import org.codehaus.metaclass.model.MethodDescriptor;
import org.codehaus.metaclass.model.ParameterDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMMetaClassDeserializer {
    public ClassDescriptor buildClassDescriptor(Document document) throws Exception {
        return this.buildClassDescriptor(document.getDocumentElement());
    }

    public ClassDescriptor buildClassDescriptor(Element element) throws Exception {
        this.expectElement(element, "class");
        String type = this.expectAttribute(element, "type");
        Attribute[] attributes = Attribute.EMPTY_SET;
        MethodDescriptor[] methods = MethodDescriptor.EMPTY_SET;
        FieldDescriptor[] fields = FieldDescriptor.EMPTY_SET;
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            Element child = (Element)node;
            String childName = child.getNodeName();
            if (childName.equals("methods")) {
                methods = this.buildMethods(child);
                continue;
            }
            if (childName.equals("fields")) {
                fields = this.buildFields(child);
                continue;
            }
            attributes = this.buildAttributes(child);
        }
        return new ClassDescriptor(type, attributes, attributes, fields, methods);
    }

    MethodDescriptor[] buildMethods(Element element) throws Exception {
        this.expectElement(element, "methods");
        ArrayList<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            MethodDescriptor field = this.buildMethod((Element)node);
            methods.add(field);
        }
        return methods.toArray(new MethodDescriptor[methods.size()]);
    }

    MethodDescriptor buildMethod(Element element) throws Exception {
        this.expectElement(element, "method");
        String name = this.expectAttribute(element, "name");
        String type = this.expectAttribute(element, "type");
        Attribute[] attributes = Attribute.EMPTY_SET;
        ParameterDescriptor[] parameters = ParameterDescriptor.EMPTY_SET;
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            Element child = (Element)node;
            String childName = child.getNodeName();
            if (childName.equals("parameters")) {
                parameters = this.buildParameters(child);
                continue;
            }
            attributes = this.buildAttributes(child);
        }
        return new MethodDescriptor(name, type, parameters, attributes, attributes);
    }

    ParameterDescriptor[] buildParameters(Element element) throws Exception {
        this.expectElement(element, "parameters");
        ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            ParameterDescriptor parameter = this.buildParameter((Element)node);
            parameters.add(parameter);
        }
        return parameters.toArray(new ParameterDescriptor[parameters.size()]);
    }

    ParameterDescriptor buildParameter(Element element) throws Exception {
        this.expectElement(element, "parameter");
        String name = this.expectAttribute(element, "name");
        String type = this.expectAttribute(element, "type");
        return new ParameterDescriptor(name, type);
    }

    FieldDescriptor[] buildFields(Element element) throws Exception {
        this.expectElement(element, "fields");
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            FieldDescriptor field = this.buildField((Element)node);
            fields.add(field);
        }
        return fields.toArray(new FieldDescriptor[fields.size()]);
    }

    FieldDescriptor buildField(Element element) throws Exception {
        this.expectElement(element, "field");
        String name = this.expectAttribute(element, "name");
        String type = this.expectAttribute(element, "type");
        Attribute[] attributes = Attribute.EMPTY_SET;
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            attributes = this.buildAttributes((Element)node);
        }
        return new FieldDescriptor(name, type, attributes, attributes);
    }

    Attribute[] buildAttributes(Element element) throws Exception {
        this.expectElement(element, "attributes");
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            Attribute attribute = this.buildAttribute((Element)node);
            attributes.add(attribute);
        }
        return attributes.toArray(new Attribute[attributes.size()]);
    }

    Attribute buildAttribute(Element element) throws Exception {
        this.expectElement(element, "attribute");
        String name = this.expectAttribute(element, "name");
        StringBuffer sb = new StringBuffer();
        Properties parameters = new Properties();
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                this.buildParam((Element)node, parameters);
                continue;
            }
            if (nodeType != 3 && nodeType != 4) continue;
            String value = node.getNodeValue();
            sb.append(value);
        }
        String value = sb.toString().trim();
        if (0 != value.length() && 0 < ((Hashtable)parameters).size()) {
            String message = "Attribute named " + name + " specified both a value (" + value + ") " + "and parameters (" + parameters + ").";
            throw new Exception(message);
        }
        if (0 == value.length()) {
            return new Attribute(name, parameters);
        }
        return new Attribute(name, value);
    }

    void buildParam(Element element, Properties parameters) throws Exception {
        this.expectElement(element, "param");
        String name = this.expectAttribute(element, "name");
        String value = this.expectAttribute(element, "value");
        parameters.setProperty(name, value);
    }

    void expectElement(Element element, String name) throws Exception {
        String actual = element.getTagName();
        if (!actual.equals(name)) {
            String message = "Unexpected element. Expected: " + name + ". Actual: " + actual + " @ " + this.getPathDescription(element) + ".";
            throw new Exception(message);
        }
    }

    String expectAttribute(Element element, String name) throws Exception {
        Attr actual = element.getAttributeNode(name);
        if (null == actual) {
            String message = "Element named " + element.getTagName() + " missing attribute named " + name + " @ " + this.getPathDescription(element) + ".";
            throw new Exception(message);
        }
        return actual.getValue();
    }

    String getPathDescription(Element cause) {
        StringBuffer sb = new StringBuffer();
        Element element = cause;
        while (true) {
            if (sb.length() > 0) {
                sb.insert(0, "/");
            }
            sb.insert(0, element.getNodeName());
            Node parentNode = element.getParentNode();
            if (!(parentNode instanceof Element)) break;
            element = (Element)parentNode;
        }
        return sb.toString();
    }
}

