/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.ide.eclipse.core.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.avalon.ide.eclipse.core.resource.SystemResource;
import org.apache.avalon.ide.eclipse.core.tools.DynProjectParam;
import org.eclipse.core.resources.IProject;

public class TemplateResource {
    private IProject project;
    private DynProjectParam parameter;
    private String templatePath;

    public TemplateResource(IProject project) {
        this.project = project;
    }

    private void createFromTemplate(String templateName, DynProjectParam map, String destinationPath) {
        try {
            String line;
            FileInputStream input = new FileInputStream(new File(templateName));
            InputStreamReader file = new InputStreamReader(input);
            BufferedReader reader = new BufferedReader(file);
            String outPath = destinationPath;
            FileOutputStream ostream = new FileOutputStream(outPath);
            OutputStreamWriter out = new OutputStreamWriter(ostream);
            Iterator it = map.keySet().iterator();
            while ((line = reader.readLine()) != null) {
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!key.startsWith("%") || line.indexOf(key) == -1) continue;
                    line = SystemResource.replaceAll(line, key, (String)map.get(key));
                }
                out.write(line);
                out.write("\n");
                it = map.keySet().iterator();
            }
            out.close();
            file.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String replaceParam(String line, DynProjectParam map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith("%") || line.indexOf(key) == -1) continue;
            line = SystemResource.replaceAll(line, key, (String)map.get(key));
        }
        return line;
    }

    public void createTemplate(String destinationPath, String templateName) {
        this.createFromTemplate(this.templatePath + templateName, this.parameter, destinationPath);
    }

    public void setTemplateSourcePath(String string) {
        this.templatePath = string;
    }

    public void setParameter(DynProjectParam param) {
        this.parameter = param;
    }
}

