/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.core.properties;

import com.arjuna.ats.arjuna.common.CoordinatorEnvironmentBean;
import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.RecoveryEnvironmentBean;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.util.List;
import me.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import org.springframework.beans.factory.InitializingBean;

public class NarayanaPropertiesInitializer
implements InitializingBean {
    private final NarayanaProperties properties;

    public NarayanaPropertiesInitializer(NarayanaProperties narayanaProperties) {
        this.properties = narayanaProperties;
    }

    public void afterPropertiesSet() {
        this.setNodeIdentifier(this.properties.getTransactionManagerId());
        this.setXARecoveryNodes(this.properties.getXaRecoveryNodes());
        this.setObjectStoreDir(this.properties.getLogDir());
        this.setCommitOnePhase(this.properties.isOnePhaseCommit());
        this.setDefaultTimeout(this.properties.getDefaultTimeout());
        this.setPeriodicRecoveryPeriod(this.properties.getPeriodicRecoveryPeriod());
        this.setRecoveryBackoffPeriod(this.properties.getRecoveryBackoffPeriod());
        this.setXaResourceOrphanFilters(this.properties.getXaResourceOrphanFilters());
        this.setRecoveryModules(this.properties.getRecoveryModules());
        this.setExpiryScanners(this.properties.getExpiryScanners());
    }

    private void setNodeIdentifier(String nodeIdentifier) {
        try {
            this.getPopulator(CoreEnvironmentBean.class).setNodeIdentifier(nodeIdentifier);
        }
        catch (CoreEnvironmentBeanException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setXARecoveryNodes(List<String> xaRecoveryNodes) {
        this.getPopulator(JTAEnvironmentBean.class).setXaRecoveryNodes(xaRecoveryNodes);
    }

    private void setObjectStoreDir(String objectStoreDir) {
        if (objectStoreDir != null) {
            this.getPopulator(ObjectStoreEnvironmentBean.class).setObjectStoreDir(objectStoreDir);
            this.getPopulator(ObjectStoreEnvironmentBean.class, "communicationStore").setObjectStoreDir(objectStoreDir);
            this.getPopulator(ObjectStoreEnvironmentBean.class, "stateStore").setObjectStoreDir(objectStoreDir);
        }
    }

    private void setCommitOnePhase(boolean isCommitOnePhase) {
        this.getPopulator(CoordinatorEnvironmentBean.class).setCommitOnePhase(isCommitOnePhase);
    }

    private void setDefaultTimeout(int defaultTimeout) {
        this.getPopulator(CoordinatorEnvironmentBean.class).setDefaultTimeout(defaultTimeout);
    }

    private void setPeriodicRecoveryPeriod(int periodicRecoveryPeriod) {
        this.getPopulator(RecoveryEnvironmentBean.class).setPeriodicRecoveryPeriod(periodicRecoveryPeriod);
    }

    private void setRecoveryBackoffPeriod(int recoveryBackoffPeriod) {
        this.getPopulator(RecoveryEnvironmentBean.class).setRecoveryBackoffPeriod(recoveryBackoffPeriod);
    }

    private void setXaResourceOrphanFilters(List<String> xaResourceOrphanFilters) {
        this.getPopulator(JTAEnvironmentBean.class).setXaResourceOrphanFilterClassNames(xaResourceOrphanFilters);
    }

    private void setRecoveryModules(List<String> recoveryModules) {
        this.getPopulator(RecoveryEnvironmentBean.class).setRecoveryModuleClassNames(recoveryModules);
    }

    private void setExpiryScanners(List<String> expiryScanners) {
        this.getPopulator(RecoveryEnvironmentBean.class).setExpiryScannerClassNames(expiryScanners);
    }

    private <T> T getPopulator(Class<T> beanClass) {
        return (T)BeanPopulator.getDefaultInstance(beanClass);
    }

    private <T> T getPopulator(Class<T> beanClass, String name) {
        return (T)BeanPopulator.getNamedInstance(beanClass, (String)name);
    }
}

