/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.core.jdbc;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import me.snowdrop.boot.narayana.core.jdbc.AbstractXADataSourceWrapper;
import me.snowdrop.boot.narayana.core.properties.RecoveryCredentialsProperties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;

public class PooledXADataSourceWrapper
extends AbstractXADataSourceWrapper {
    private final Map<String, String> properties;
    private final TransactionManager transactionManager;

    public PooledXADataSourceWrapper(TransactionManager transactionManager, XARecoveryModule xaRecoveryModule, Map<String, String> properties) {
        this(transactionManager, xaRecoveryModule, properties, RecoveryCredentialsProperties.DEFAULT);
    }

    public PooledXADataSourceWrapper(TransactionManager transactionManager, XARecoveryModule xaRecoveryModule, Map<String, String> properties, RecoveryCredentialsProperties recoveryCredentials) {
        super(xaRecoveryModule, recoveryCredentials);
        this.properties = properties;
        this.transactionManager = transactionManager;
    }

    @Override
    protected DataSource wrapDataSourceInternal(XADataSource xaDataSource) throws Exception {
        BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();
        BasicDataSource basicDataSource = this.getBasicDataSource();
        this.copyFields(basicDataSource, basicManagedDataSource);
        basicManagedDataSource.setTransactionManager(this.transactionManager);
        basicManagedDataSource.setXaDataSourceInstance(xaDataSource);
        int initialSize = Integer.valueOf(this.properties.getOrDefault("initialSize", "0"));
        if (initialSize > 0) {
            basicManagedDataSource.setInitialSize(initialSize);
            basicManagedDataSource.getLogWriter();
        }
        return basicManagedDataSource;
    }

    private BasicDataSource getBasicDataSource() throws Exception {
        Properties dbcpProperties = new Properties();
        dbcpProperties.putAll(this.properties);
        dbcpProperties.put("initialSize", "0");
        return BasicDataSourceFactory.createDataSource((Properties)dbcpProperties);
    }

    private void copyFields(Object source, Object destination) throws IllegalAccessException {
        for (Field field : source.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(source) == null || Modifier.isFinal(field.getModifiers())) continue;
            field.set(destination, field.get(source));
        }
    }
}

