/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.core.jms;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import me.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import org.jboss.narayana.jta.jms.ConnectionFactoryProxy;
import org.jboss.narayana.jta.jms.JmsXAResourceRecoveryHelper;
import org.jboss.narayana.jta.jms.TransactionHelper;
import org.jboss.narayana.jta.jms.TransactionHelperImpl;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;

public class NarayanaXAConnectionFactoryWrapper
implements XAConnectionFactoryWrapper {
    private final TransactionManager transactionManager;
    private final XARecoveryModule xaRecoveryModule;
    private final NarayanaProperties properties;

    public NarayanaXAConnectionFactoryWrapper(TransactionManager transactionManager, XARecoveryModule xaRecoveryModule, NarayanaProperties properties) {
        this.transactionManager = transactionManager;
        this.xaRecoveryModule = xaRecoveryModule;
        this.properties = properties;
    }

    public ConnectionFactory wrapConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        XAResourceRecoveryHelper recoveryHelper = this.getRecoveryHelper(xaConnectionFactory);
        this.xaRecoveryModule.addXAResourceRecoveryHelper(recoveryHelper);
        return new ConnectionFactoryProxy(xaConnectionFactory, (TransactionHelper)new TransactionHelperImpl(this.transactionManager));
    }

    private XAResourceRecoveryHelper getRecoveryHelper(XAConnectionFactory xaConnectionFactory) {
        if (this.properties.getRecoveryJmsUser() == null && this.properties.getRecoveryJmsPass() == null) {
            return new JmsXAResourceRecoveryHelper(xaConnectionFactory);
        }
        return new JmsXAResourceRecoveryHelper(xaConnectionFactory, this.properties.getRecoveryJmsUser(), this.properties.getRecoveryJmsPass());
    }
}

