/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection.support.classloader;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import org.mc4j.ems.connection.support.classloader.deepjar.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepClassLoader
extends ClassLoader {
    private URL[] searchPaths;
    private Map<String, ByteCode> codeMap;
    private Map<String, ProtectionDomain> protectionDomainMap;
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";

    public DeepClassLoader(ClassLoader parent, URL[] urls) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls != null) {
            return cls;
        }
        String cache = name.replace('/', '.') + ".class";
        ByteCode bytecode = this.codeMap.get(cache);
        if (bytecode != null) {
            ProtectionDomain pd = this.protectionDomainMap.get(bytecode.codebase);
            if (pd == null) {
                ProtectionDomain cd = this.getClass().getProtectionDomain();
                URL url = cd.getCodeSource().getLocation();
                try {
                    url = new URL("jar:" + url + "!/" + bytecode.codebase);
                }
                catch (MalformedURLException mux) {
                    mux.printStackTrace(System.out);
                }
                CodeSource source = new CodeSource(url, (CodeSigner[])null);
                pd = new ProtectionDomain(source, null, this, null);
                this.protectionDomainMap.put(bytecode.codebase, pd);
            }
            return this.defineClass(name, bytecode.bytes, 0, bytecode.length, pd);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String resourceName) {
        try {
            String resource = this.resolve(resourceName);
            if (resource != null) {
                return new URL(Handler.PROTOCOL + ":" + resource);
            }
            return null;
        }
        catch (MalformedURLException mux) {
            System.out.println("Unable to find resource " + resourceName);
            return null;
        }
    }

    protected String resolve(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        resourceName = resourceName.replace('/', '.');
        String resource = null;
        if (resource == null) {
            resource = this.codeMap.get(resourceName) == null ? null : resourceName;
        }
        return resource;
    }

    static {
        String handlerPackage = "org.mc4j.ems.connection.support.classloader.deepjar";
        String existingHandlers = System.getProperty(JAVA_PROTOCOL_HANDLER);
        String newHandlers = null;
        newHandlers = existingHandlers != null && existingHandlers.length() > 0 ? handlerPackage + "|" + existingHandlers : handlerPackage;
        System.setProperty(JAVA_PROTOCOL_HANDLER, newHandlers);
    }

    protected class ByteCode {
        public byte[] bytes;
        public int length;
        public String name;
        public String original;
        public String codebase;

        public ByteCode(String name, String $original, byte[] bytes, int length, String codebase) {
            this.name = name;
            this.original = $original;
            this.bytes = bytes;
            this.codebase = codebase;
        }
    }
}

