/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection.settings.persistence;

import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import org.mc4j.ems.connection.EmsException;
import org.mc4j.ems.connection.settings.ConnectionSettings;

public class ConnectionSettingPersistence {
    private static final ConnectionSettingPersistence INSTANCE = new ConnectionSettingPersistence();

    public static ConnectionSettingPersistence getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encodeSettings(ConnectionSettings settings) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(settings.getClass().getClassLoader());
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(os));
            e.setExceptionListener(new ExceptionListener(){

                public void exceptionThrown(Exception e) {
                    throw new EmsException("Could not encode connection settings", e);
                }
            });
            e.setPersistenceDelegate(File.class, new PersistenceDelegate(){

                protected Expression instantiate(Object oldInstance, Encoder out) {
                    File f = (File)oldInstance;
                    return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{f.getAbsolutePath()});
                }
            });
            e.writeObject(settings);
            e.close();
            e.flush();
            String string = os.toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionSettings decodeSettings(String xml) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ConnectionSettings.class.getClassLoader());
        try {
            ConnectionSettings newSettings;
            XMLDecoder dec = new XMLDecoder(new ByteArrayInputStream(xml.getBytes()));
            ConnectionSettings connectionSettings = newSettings = (ConnectionSettings)dec.readObject();
            return connectionSettings;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }
}

