/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import javax.management.MBeanServer;
import org.mc4j.ems.connection.EmsConnectException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionListener;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.DConnection;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.StatsProxy;

public abstract class AbstractConnectionProvider
implements ConnectionProvider {
    protected ConnectionSettings connectionSettings;
    private boolean connected = false;
    protected boolean connectionFailure = false;
    protected DConnection existingConnection;
    protected List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private Timer refreshTimer;
    private StatsProxy statsProxy;
    protected int connectionRoundTrips;

    public abstract MBeanServer getMBeanServer();

    public Object getMEJB() {
        return null;
    }

    @Override
    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public int compareTo(Object o) {
        ConnectionProvider otherProvider = (ConnectionProvider)o;
        return this.connectionSettings.getConnectionName().compareTo(otherProvider.getConnectionSettings().getConnectionName());
    }

    @Override
    public void initialize(ConnectionSettings settings) {
        this.connectionSettings = settings;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Deprecated
    public void setConnected(boolean connected) throws Exception {
        if (connected) {
            this.connect();
        } else {
            this.disconnect();
        }
    }

    @Override
    public final EmsConnection connect() {
        if (this.existingConnection != null) {
            this.existingConnection.unload();
        }
        try {
            this.doConnect();
            this.connected = true;
            this.connectionFailure = false;
        }
        catch (Exception e) {
            throw new EmsConnectException("Could not connect [" + this.connectionSettings.getServerUrl() + "] " + e, e);
        }
        if (this.existingConnection == null) {
            DConnection connection;
            this.existingConnection = connection = new DConnection("unknown", this);
        } else {
            this.existingConnection.setConnectionProvider(this);
        }
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connect();
        }
        return this.existingConnection;
    }

    @Override
    public EmsConnection getExistingConnection() {
        return this.existingConnection;
    }

    protected abstract void doConnect() throws Exception;

    @Override
    public final void disconnect() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
        this.connected = false;
        this.connectionFailure = false;
        try {
            this.doDisconnect();
        }
        catch (Exception e) {
            throw new EmsConnectException("Could not close connection " + e.toString(), e);
        }
        for (ConnectionListener listener : this.connectionListeners) {
            listener.disconnect();
        }
    }

    protected void doDisconnect() throws Exception {
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    @Override
    public long getRoundTrips() {
        if (this.statsProxy != null) {
            return this.statsProxy.getRoundTrips();
        }
        return 0L;
    }

    @Override
    public long getFailures() {
        if (this.statsProxy != null) {
            return this.statsProxy.getFailures();
        }
        return 0L;
    }

    public StatsProxy getStatsProxy() {
        return this.statsProxy;
    }

    public void setStatsProxy(StatsProxy statsProxy) {
        this.statsProxy = statsProxy;
    }
}

