/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection.support.metadata;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;

public abstract class AbstractConnectionTypeDescriptor
implements ConnectionTypeDescriptor {
    private static Log log = LogFactory.getLog(AbstractConnectionTypeDescriptor.class);

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public boolean isUseManagementHome() {
        return false;
    }

    @Override
    public String getServerVersion(File recognitionFile) {
        try {
            JarFile recJarFile = new JarFile(recognitionFile);
            String version = recJarFile.getManifest().getMainAttributes().getValue("Implementation-Version");
            if (version == null) {
                Map<String, Attributes> attrMap = recJarFile.getManifest().getEntries();
                for (Map.Entry<String, Attributes> entry : attrMap.entrySet()) {
                    String name = entry.getKey();
                    Attributes attr = entry.getValue();
                    version = attr.getValue("Implementation-Version");
                }
            }
            return version;
        }
        catch (MalformedURLException e) {
            log.warn((Object)("Could not determine server version from matched file " + recognitionFile.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)("Could not determine server version from matched file " + recognitionFile.getAbsolutePath()), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getExtrasLibrary() {
        return null;
    }

    @Override
    public Properties getDefaultAdvancedProperties() {
        return new Properties();
    }

    @Override
    public boolean isUseChildFirstClassLoader() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractConnectionTypeDescriptor)) {
            return false;
        }
        AbstractConnectionTypeDescriptor other = (AbstractConnectionTypeDescriptor)o;
        return !(this.getDisplayName() != null ? !this.getDisplayName().equals(other.getDisplayName()) : other.getDisplayName() != null);
    }

    public int hashCode() {
        return this.getDisplayName() != null ? this.getDisplayName().hashCode() : 0;
    }
}

