/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.bean.attribute;

import java.io.NotSerializableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsException;
import org.mc4j.ems.connection.bean.attribute.AttributeChangeListener;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.impl.jmx.connection.bean.DMBean;

public class DAttribute
implements EmsAttribute {
    private static Log log = LogFactory.getLog(DAttribute.class);
    protected MBeanAttributeInfo info;
    protected DMBean bean;
    protected boolean loaded;
    protected boolean supportedType = true;
    protected Object currentValue;
    protected LinkedList<Throwable> failures;
    private static final Set<Class> NUMERIC_TYPES = new HashSet<Class>();
    private static final Map<String, Class> TYPES;

    public DAttribute(MBeanAttributeInfo info, DMBean bean) {
        this.info = info;
        this.bean = bean;
        this.init();
    }

    protected void init() {
    }

    private String getControlProperty(String property, String defaultValue) {
        return this.bean.getConnectionProvider().getConnectionSettings().getControlProperties().getProperty(property, defaultValue);
    }

    public synchronized void registerAttributeChangeListener(AttributeChangeListener listener) {
    }

    @Override
    public Object getValue() {
        if (!this.loaded) {
            this.refresh();
        }
        return this.currentValue;
    }

    @Override
    public int getValueSize() {
        return 0;
    }

    @Override
    public void setValue(Object newValue) throws Exception {
        try {
            MBeanServer server = this.bean.getConnectionProvider().getMBeanServer();
            server.setAttribute(this.bean.getObjectName(), new Attribute(this.getName(), newValue));
            this.alterValue(newValue);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        this.refresh();
    }

    @Override
    public void alterValue(Object newValue) {
        if (newValue != null && !newValue.equals(this.currentValue) || newValue == null && this.currentValue != null) {
            this.currentValue = newValue;
        }
    }

    protected boolean storeHistory(Object value) {
        return value instanceof Number;
    }

    @Override
    public synchronized Object refresh() {
        this.loaded = true;
        Object newValue = null;
        try {
            MBeanServer server = this.bean.getConnectionProvider().getMBeanServer();
            newValue = server.getAttribute(this.bean.getObjectName(), this.getName());
        }
        catch (ReflectionException e) {
            this.supportedType = false;
            this.registerFailure(e);
            throw new EmsException("Could not load attribute value " + e.toString(), e);
        }
        catch (InstanceNotFoundException e) {
            this.registerFailure(e);
            throw new EmsException("Could not load attribute value, bean instance not found " + this.bean.getObjectName().toString(), e);
        }
        catch (MBeanException e) {
            this.registerFailure(e);
            Exception t = e.getTargetException();
            if (t != null) {
                throw new EmsException("Could not load attribute value, target bean threw exception " + t.getLocalizedMessage(), t);
            }
            throw new EmsException("Could not load attribute value " + e.getLocalizedMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            this.registerFailure(e);
            throw new EmsException("Could not load attribute value, attribute [" + this.getName() + "] not found", e);
        }
        catch (UndeclaredThrowableException e) {
            if (e.getUndeclaredThrowable() instanceof InvocationTargetException) {
                Throwable t = e.getCause();
                if (t.getCause() instanceof NotSerializableException) {
                    this.supportedType = false;
                    this.registerFailure(t.getCause());
                    throw new EmsException("Could not load attribute value " + t.getLocalizedMessage(), t.getCause());
                }
                throw new EmsException("Could not load attribute value " + t.getLocalizedMessage(), t);
            }
            throw new EmsException("Could not load attribute value " + e.getLocalizedMessage(), e);
        }
        catch (RuntimeException re) {
            this.supportedType = false;
            this.registerFailure(re);
            throw new EmsException("Could not load attribute value " + re.getLocalizedMessage(), re);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.supportedType = false;
            this.registerFailure(ncdfe);
            throw new EmsException("Could not load attribute value " + ncdfe.getLocalizedMessage(), ncdfe);
        }
        catch (Throwable t) {
            throw new EmsException("Could not load attribute value " + t.getLocalizedMessage(), t);
        }
        this.alterValue(newValue);
        return newValue;
    }

    public List<Throwable> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    protected void registerFailure(Throwable t) {
        if (this.failures == null) {
            this.failures = new LinkedList();
        }
        this.failures.add(t);
        if (this.failures.size() > 2) {
            this.failures.removeFirst();
        }
        log.debug((Object)("Attribute access failure " + t.getLocalizedMessage()), t);
    }

    @Override
    public String getName() {
        return this.info.getName();
    }

    @Override
    public String getType() {
        return this.info.getType();
    }

    @Override
    public Class getTypeClass() {
        if (TYPES.containsKey(this.getType())) {
            return TYPES.get(this.getType());
        }
        try {
            return Class.forName(this.getType(), true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isNumericType() {
        return NUMERIC_TYPES.contains(this.getTypeClass());
    }

    @Override
    public String getDescription() {
        return this.info.getDescription();
    }

    @Override
    public boolean isWritable() {
        return this.info.isWritable();
    }

    @Override
    public boolean isReadable() {
        return this.info.isReadable();
    }

    @Override
    public boolean isSupportedType() {
        return this.supportedType;
    }

    @Override
    public void setSupportedType(boolean supportedType) {
        this.supportedType = supportedType;
    }

    public int compareTo(Object o) {
        DAttribute otherAttribute = (DAttribute)o;
        return this.getName().compareTo(otherAttribute.getName());
    }

    static {
        NUMERIC_TYPES.add(Short.TYPE);
        NUMERIC_TYPES.add(Short.class);
        NUMERIC_TYPES.add(Integer.TYPE);
        NUMERIC_TYPES.add(Integer.class);
        NUMERIC_TYPES.add(Long.TYPE);
        NUMERIC_TYPES.add(Long.class);
        NUMERIC_TYPES.add(Float.TYPE);
        NUMERIC_TYPES.add(Float.class);
        NUMERIC_TYPES.add(Double.TYPE);
        NUMERIC_TYPES.add(Double.class);
        NUMERIC_TYPES.add(BigInteger.class);
        NUMERIC_TYPES.add(BigDecimal.class);
        TYPES = new HashMap<String, Class>();
        TYPES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        TYPES.put(Character.TYPE.getName(), Character.TYPE);
        TYPES.put(Byte.TYPE.getName(), Byte.TYPE);
        TYPES.put(Short.TYPE.getName(), Short.TYPE);
        TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        TYPES.put(Long.TYPE.getName(), Long.TYPE);
        TYPES.put(Float.TYPE.getName(), Float.TYPE);
        TYPES.put(Double.TYPE.getName(), Double.TYPE);
        TYPES.put(Void.TYPE.getName(), Void.TYPE);
    }
}

