/*
 * Copyright 2002-2004 Greg Hinkle
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.mc4j.ems.connection.bean.attribute;

import org.mc4j.ems.store.ValueHistory;

/**
 * @author Greg Hinkle (ghinkle@users.sourceforge.net), Apr 4, 2005
 * @version $Revision: 1.2 $($Author: ghinkl $ / $Date: 2006/04/12 19:11:33 $)
 */
public interface EmsAttribute extends Comparable {
    /** Default true */
    String CONTROL_ATTRIBUTE_HISTORY = "Attribute.history";
    /** Default CompleteValueHistory */
    String CONTROL_ATTRIBUTE_HISTORY_CLASS = "Attribute.history.class";
    /** Default 1 */
    String CONTROL_ATTRIBUTE_HISTORY_DEPTH = "Attribute.history.depth";


    void registerAttributeChangeListener(AttributeChangeListener listener);
    Object getValue();

    /**
     * Set the attribute on the server
     * @param newValue The value to be set
     * @throws Exception
     */
    void setValue(Object newValue) throws Exception;
    /**
     * Alters the internally stored value of this attribute. Does not update the
     * server value. Is intended for mass load of attribute data via the MBean.
     * @param newValue
     */
    void alterValue(Object newValue);


    /**
     * Updates the local value of this mbean from the server
     */
    Object refresh();

    ValueHistory getValueHistory();

    String getName();
    String getType();

    Class getTypeClass();

    boolean isNumericType();

    String getDescription() ;


    boolean isReadable();
    boolean isWritable();


    boolean isSupportedType();

    void setSupportedType(boolean supportedType);


    int getValueSize();
}
