/*
 * Copyright 2002-2004 Greg Hinkle
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.mc4j.ems.connection.bean;

import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.notification.EmsNotification;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.mc4j.ems.connection.support.ConnectionProvider;

import java.util.List;
import java.util.SortedSet;

/**
 * @author Greg Hinkle (ghinkle@users.sourceforge.net), Apr 4, 2005
 * @version $Revision: 1.2 $($Author: ghinkl $ / $Date: 2006/04/12 19:11:35 $)
 */
public interface EmsBean extends Comparable {

    EmsBeanName getBeanName();

    ConnectionProvider getConnectionProvider();

    <T> T getProxy(Class<T> beanInterface);

    void loadSynchronous() ;

    EmsAttribute getAttribute(String name);

    SortedSet<EmsAttribute> getAttributes();


    /**
     * Refresh, from the server, all attribute values for an MBean
     * @return the List<EmsAttribute> attribute list
     */
    List<EmsAttribute> refreshAttributes();

    /**
     * Return a specific subset of EmsAttributes for a bean based on
     * the requested list of attributes by name.
     * This method can be used to load a group of attributes with a single
     * server call. Attributes updated in this fashion do update their
     * internal representation and do fire events on the changes.
     * @param attributeNames the names of attributes to load.
     * @return the list of requested attribute objects updated
     */
    List<EmsAttribute> refreshAttributes(List<String> attributeNames);

    String getClassTypeName();

    Class getClassType() throws ClassNotFoundException;

    EmsOperation getOperation(String name);

    SortedSet<EmsOperation> getOperations();

    EmsNotification getNotification(String name);

    SortedSet<EmsNotification> getNotifications();

    void unregister();

    /**
     * This runs an live mbean server request to check that the
     * MBean represented by this bean is still registered.
     * @return true if the MBean is still registered in the MBeanServer
     */
    boolean isRegistered();

    boolean isNotificationEmiter();

    boolean isHasUnsupportedType();
}
