/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.maven.fetch.exceptions.FetchException;
import org.apache.maven.fetch.exceptions.ResourceNotFoundFetchException;
import org.apache.maven.fetch.util.IOUtility;
import org.apache.maven.proxy.DefaultRetrievalComponent;
import org.apache.maven.proxy.config.RepoConfiguration;
import org.apache.maven.proxy.config.RetrievalComponentConfiguration;

public class RepositoryServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$org$apache$maven$proxy$RepositoryServlet == null ? (class$org$apache$maven$proxy$RepositoryServlet = RepositoryServlet.class$("org.apache.maven.proxy.RepositoryServlet")) : class$org$apache$maven$proxy$RepositoryServlet));
    private RetrievalComponentConfiguration rcc = null;
    private File localStoreDir;
    static /* synthetic */ Class class$org$apache$maven$proxy$RepositoryServlet;

    public void destroy() {
        this.rcc = null;
        this.localStoreDir = null;
        super.destroy();
    }

    protected long getLastModified(HttpServletRequest request) {
        LOGGER.debug((Object)("Checking getLastModified(): " + request.getPathInfo()));
        File f = this.getFileForRequest(request);
        if (f.exists() && f.isFile()) {
            return f.lastModified();
        }
        return super.getLastModified(request);
    }

    public void init() throws ServletException {
        this.rcc = (RetrievalComponentConfiguration)this.getServletContext().getAttribute("config");
        this.localStoreDir = new File(this.rcc.getLocalStore());
        if (!this.localStoreDir.exists()) {
            LOGGER.info((Object)("Local Repository (" + this.localStoreDir.getAbsolutePath() + ") does not exist"));
        }
    }

    public File getFileForRequest(HttpServletRequest request) {
        return new File(this.localStoreDir, request.getPathInfo());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        LOGGER.info((Object)("Received request: " + pathInfo));
        if (this.rcc.isBrowsable()) {
            if (pathInfo.equalsIgnoreCase("/favicon.ico")) {
                this.handleImageRequest("favicon.ico", "image/x-ico", response);
                return;
            }
            if (pathInfo.equalsIgnoreCase("/jar.png")) {
                this.handleImageRequest("jar.png", "image/png", response);
                return;
            }
            if (pathInfo.equalsIgnoreCase("/parent.png")) {
                this.handleImageRequest("parent.png", "image/png", response);
                return;
            }
        }
        if (pathInfo.endsWith("/")) {
            if (this.rcc.isBrowsable()) {
                this.handleBrowseRequest(request, response);
            } else {
                response.sendError(403);
            }
            return;
        }
        this.handleDownloadRequest(request, response);
    }

    private void handleImageRequest(String image, String type, HttpServletResponse response) throws IOException {
        response.setContentType(type);
        ServletOutputStream os = response.getOutputStream();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(image);
        IOUtility.transferStream((InputStream)is, (OutputStream)os);
        IOUtility.close((InputStream)is);
    }

    private void handleDownloadRequest(HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException, IOException {
        try {
            boolean done = false;
            List repos = this.rcc.getRepos();
            DefaultRetrievalComponent rc = new DefaultRetrievalComponent();
            for (int i = 0; i < repos.size(); ++i) {
                RepoConfiguration repoConfig = (RepoConfiguration)repos.get(i);
                try {
                    File f = new File(this.localStoreDir, request.getPathInfo());
                    f.getParentFile().mkdirs();
                    if (f.exists()) {
                        LOGGER.info((Object)("Retrieving from cache: " + f.getAbsolutePath()));
                    } else {
                        rc.retrieveArtifact(repoConfig, f, request.getPathInfo());
                    }
                    FileInputStream is = new FileInputStream(f);
                    response.setContentType("application/x-jar");
                    ServletOutputStream os = response.getOutputStream();
                    IOUtility.transferStream((InputStream)is, (OutputStream)os);
                    IOUtility.close((InputStream)is);
                    done = true;
                    break;
                }
                catch (ResourceNotFoundFetchException ex) {
                    continue;
                }
            }
            if (!done) {
                LOGGER.warn((Object)("Could not find upstream resource :" + request.getPathInfo()));
                response.sendError(404, "Could not find " + request.getPathInfo());
            }
        }
        catch (FetchException e) {
            e.printStackTrace();
            response.sendError(500, e.getLocalizedMessage());
        }
    }

    private void handleBrowseRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        PrintWriter pw = response.getWriter();
        pw.println("<html>");
        pw.println("<head>");
        pw.println("  <title>maven-proxy</title>");
        pw.println("  <style type='text/css'>");
        pw.println("    * { font-family: tahoma,verdana,arial; }");
        pw.println("    tr.dir { left-margin: 1cm; }");
        pw.println("  </style>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<div>Browsing " + pathInfo + "</div>");
        File dir = new File(this.localStoreDir, pathInfo);
        File[] files = dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        pw.println("<table width='100%'>");
        pw.println("<colgroup>");
        pw.println("  <col width='20px'>");
        pw.println("  <col width='*'>");
        pw.println("  <col width='5*'>");
        pw.println("</colgroup>");
        pw.println("<tr class='dir'><td><img src='/parent.png' alt=''/></td><td/><td><a href='..'>..</a></td><td></td></tr>");
        for (int i = 0; i < files.length; ++i) {
            File theFile = files[i];
            if (theFile.isDirectory()) {
                pw.println("<tr class='dir'><td><a href='" + pathInfo + theFile.getName() + "/'>" + theFile.getName() + "</a></td><td></td></tr>");
                continue;
            }
            pw.println("<tr class='file'><td><img src='/jar.png' alt=''/></td><td>" + theFile.length() + "</td><td><a href='" + pathInfo + theFile.getName() + "'>" + theFile.getName() + "</a></td></tr>");
        }
        pw.println("</table>");
        pw.println("</body>");
        pw.println("</html>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

