/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.transport.event;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import link.thingscloud.freeswitch.esl.transport.message.EslHeaders;
import link.thingscloud.freeswitch.esl.transport.message.EslMessage;
import link.thingscloud.freeswitch.esl.transport.util.HeaderParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EslEvent {
    private static final Logger log = LoggerFactory.getLogger(EslEvent.class);
    private final Map<EslHeaders.Name, String> messageHeaders;
    private final Map<String, String> eventHeaders;
    private final List<String> eventBody;
    private final boolean decodeEventHeaders = true;

    public EslEvent(EslMessage rawMessage) {
        this(rawMessage, false);
    }

    public EslEvent(EslMessage rawMessage, boolean parseCommandReply) {
        this.messageHeaders = rawMessage.getHeaders();
        this.eventHeaders = new HashMap<String, String>(rawMessage.getBodyLines().size());
        this.eventBody = new ArrayList<String>();
        if (rawMessage.getContentType().equals("text/event-plain")) {
            this.parsePlainBody(rawMessage.getBodyLines());
        } else {
            if (rawMessage.getContentType().equals("text/event-xml")) {
                throw new IllegalStateException("XML events are not yet supported");
            }
            if (rawMessage.getContentType().equals("command/reply") && parseCommandReply) {
                this.parsePlainBody(rawMessage.getBodyLines());
            } else {
                throw new IllegalStateException("Unexpected EVENT content-type: " + rawMessage.getContentType());
            }
        }
    }

    public Map<EslHeaders.Name, String> getMessageHeaders() {
        return this.messageHeaders;
    }

    public Map<String, String> getEventHeaders() {
        return this.eventHeaders;
    }

    public List<String> getEventBodyLines() {
        return this.eventBody;
    }

    public String getEventName() {
        return this.getEventHeaders().get("Event-Name");
    }

    public long getEventDateTimestamp() {
        return Long.valueOf(this.getEventHeaders().get("Event-Date-Timestamp"));
    }

    public String getEventDateLocal() {
        return this.getEventHeaders().get("Event-Date-Local");
    }

    public String getEventDateGmt() {
        return this.getEventHeaders().get("Event-Date-GMT");
    }

    public boolean hasEventBody() {
        return !this.eventBody.isEmpty();
    }

    private void parsePlainBody(List<String> rawBodyLines) {
        boolean isEventBody = false;
        for (String rawLine : rawBodyLines) {
            if (!isEventBody) {
                String[] headerParts = HeaderParser.splitHeader(rawLine);
                try {
                    String decodedValue = URLDecoder.decode(headerParts[1], "UTF-8");
                    log.trace("decoded from: [{}]", (Object)headerParts[1]);
                    log.trace("decoded   to: [{}]", (Object)decodedValue);
                    this.eventHeaders.put(headerParts[0], decodedValue);
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("Could not URL decode [{}]", (Object)headerParts[1]);
                    this.eventHeaders.put(headerParts[0], headerParts[1]);
                }
                if (!headerParts[0].equals("Content-Length")) continue;
                isEventBody = true;
                continue;
            }
            if (rawLine.length() <= 0) continue;
            this.eventBody.add(rawLine);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EslEvent: name=[");
        sb.append(this.getEventName());
        sb.append("] headers=");
        sb.append(this.messageHeaders.size());
        sb.append(", eventHeaders=");
        sb.append(this.eventHeaders.size());
        sb.append(", eventBody=");
        sb.append(this.eventBody.size());
        sb.append(" lines.");
        return sb.toString();
    }
}

