/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.transport;

import java.util.ArrayList;
import java.util.List;

public class SendMsg {
    private final List<String> msgLines = new ArrayList<String>();
    private final boolean hasUuid;

    public SendMsg() {
        this.msgLines.add("sendmsg");
        this.hasUuid = false;
    }

    public SendMsg(String uuid) {
        this.msgLines.add("sendmsg " + uuid);
        this.hasUuid = true;
    }

    public SendMsg addCallCommand(String command) {
        this.msgLines.add("call-command: " + command);
        return this;
    }

    public SendMsg addExecuteAppName(String appName) {
        this.msgLines.add("execute-app-name: " + appName);
        return this;
    }

    public SendMsg addExecuteAppArg(String arg) {
        this.msgLines.add("execute-app-arg: " + arg);
        return this;
    }

    public SendMsg addLoops(int count) {
        this.msgLines.add("loops: " + count);
        return this;
    }

    public SendMsg addHangupCause(String cause) {
        this.msgLines.add("hangup-cause: " + cause);
        return this;
    }

    public SendMsg addNomediaUuid(String value) {
        this.msgLines.add("nomedia-uuid: " + value);
        return this;
    }

    public SendMsg addEventLock() {
        this.msgLines.add("event-lock: true");
        return this;
    }

    public SendMsg addGenericLine(String name, String value) {
        this.msgLines.add(name + ": " + value);
        return this;
    }

    public List<String> getMsgLines() {
        return this.msgLines;
    }

    public boolean hasUuid() {
        return this.hasUuid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SendMsg: ");
        if (this.msgLines.size() > 1) {
            sb.append(this.msgLines.get(1));
        } else if (this.msgLines.size() > 0) {
            sb.append(0);
        }
        return sb.toString();
    }
}

