/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.inbound;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import link.thingscloud.freeswitch.esl.InboundClientService;
import link.thingscloud.freeswitch.esl.inbound.handler.InboundChannelHandler;
import link.thingscloud.freeswitch.esl.inbound.listener.ChannelEventListener;
import link.thingscloud.freeswitch.esl.inbound.option.InboundClientOption;
import link.thingscloud.freeswitch.esl.transport.message.EslFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNettyInboundClient
implements ChannelEventListener,
InboundClientService {
    final Bootstrap bootstrap;
    final EventLoopGroup workerGroup;
    final ExecutorService publicExecutor;
    final ExecutorService privateExecutor;
    final InboundClientOption option;
    final Logger log = LoggerFactory.getLogger(this.getClass());

    AbstractNettyInboundClient(final InboundClientOption option) {
        this.option = option;
        this.bootstrap = new Bootstrap();
        this.publicExecutor = new ScheduledThreadPoolExecutor(option.publicExecutorThread(), (ThreadFactory)new DefaultThreadFactory("publicExecutor", true));
        this.privateExecutor = new ScheduledThreadPoolExecutor(option.privateExecutorThread(), (ThreadFactory)new DefaultThreadFactory("privateExecutor", true));
        this.workerGroup = new NioEventLoopGroup(option.workerGroupThread());
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.SO_SNDBUF, (Object)option.sndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)option.rcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
                pipeline.addLast("decoder", (ChannelHandler)new EslFrameDecoder(8192));
                if (option.readerIdleTimeSeconds() > 0 && option.readTimeoutSeconds() > 0 && option.readerIdleTimeSeconds() < option.readTimeoutSeconds()) {
                    pipeline.addLast("idleState", (ChannelHandler)new IdleStateHandler(option.readerIdleTimeSeconds(), 0, 0));
                    pipeline.addLast("readTimeout", (ChannelHandler)new ReadTimeoutHandler(option.readTimeoutSeconds()));
                }
                pipeline.addLast("clientHandler", (ChannelHandler)new InboundChannelHandler(AbstractNettyInboundClient.this, AbstractNettyInboundClient.this.publicExecutor, AbstractNettyInboundClient.this.privateExecutor, option.disablePublicExecutor()));
            }
        });
    }
}

