/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.inbound;

import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import link.thingscloud.freeswitch.esl.InboundClient;
import link.thingscloud.freeswitch.esl.exception.InboundClientException;
import link.thingscloud.freeswitch.esl.inbound.AbstractNettyInboundClient;
import link.thingscloud.freeswitch.esl.inbound.handler.InboundChannelHandler;
import link.thingscloud.freeswitch.esl.inbound.listener.EventListener;
import link.thingscloud.freeswitch.esl.inbound.listener.ServerOptionListener;
import link.thingscloud.freeswitch.esl.inbound.option.ConnectState;
import link.thingscloud.freeswitch.esl.inbound.option.InboundClientOption;
import link.thingscloud.freeswitch.esl.inbound.option.ServerOption;
import link.thingscloud.freeswitch.esl.transport.CommandResponse;
import link.thingscloud.freeswitch.esl.transport.event.EslEvent;
import link.thingscloud.freeswitch.esl.transport.message.EslMessage;
import link.thingscloud.freeswitch.esl.util.StringUtils;

abstract class AbstractInboundClient
extends AbstractNettyInboundClient
implements InboundClient {
    private final ScheduledThreadPoolExecutor scheduledPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DefaultThreadFactory("scheduled-pool", true));
    private final Map<String, InboundChannelHandler> handlerTable = new ConcurrentHashMap<String, InboundChannelHandler>(32);

    AbstractInboundClient(InboundClientOption option) {
        super(option);
    }

    @Override
    public InboundClientOption option() {
        return this.option;
    }

    @Override
    public void start() {
        this.log.info("inbound client will start ...");
        this.addServerOptionListener();
        this.addEventListener();
        this.option().serverOptions().forEach(serverOption -> {
            if (serverOption.state() == ConnectState.INIT) {
                serverOption.state(ConnectState.CONNECTING);
                this.doConnect((ServerOption)serverOption);
            }
        });
    }

    @Override
    public void shutdown() {
        this.log.info("inbound client will shutdown ...");
        this.option().serverOptions().forEach(serverOption -> {
            serverOption.state(ConnectState.SHUTDOWN);
            InboundChannelHandler inboundChannelHandler = this.handlerTable.get(serverOption.addr());
            if (inboundChannelHandler != null) {
                inboundChannelHandler.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    if (future.isSuccess()) {
                        this.log.info("shutdown inbound client remote server [{}:{}] success.", (Object)serverOption.host(), (Object)serverOption.port());
                    } else {
                        this.log.info("shutdown inbound client remote server [{}:{}] failed, cause : ", new Object[]{serverOption.host(), serverOption.port(), future.cause()});
                    }
                }));
            }
        });
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public void onChannelActive(String remoteAddr, InboundChannelHandler inboundChannelHandler) {
        this.handlerTable.put(remoteAddr, inboundChannelHandler);
        this.option().serverOptions().forEach(serverOption -> {
            if (StringUtils.equals(serverOption.addr(), remoteAddr) && this.option().serverConnectionListener() != null) {
                this.option().serverConnectionListener().onOpened((ServerOption)serverOption);
            }
        });
    }

    @Override
    public void onChannelClosed(String remoteAddr) {
        this.handlerTable.remove(remoteAddr);
        this.option().serverOptions().forEach(serverOption -> {
            if (StringUtils.equals(serverOption.addr(), remoteAddr)) {
                if (this.option().serverConnectionListener() != null) {
                    this.option().serverConnectionListener().onClosed((ServerOption)serverOption);
                }
                if (serverOption.state() != ConnectState.SHUTDOWN) {
                    serverOption.state(ConnectState.CLOSED);
                    this.scheduledPoolExecutor.schedule(() -> this.doConnect((ServerOption)serverOption), (long)this.getTimeoutSeconds((ServerOption)serverOption), TimeUnit.SECONDS);
                }
            }
        });
    }

    @Override
    public void handleAuthRequest(String addr, InboundChannelHandler inboundChannelHandler) {
        this.log.info("Auth requested[{}], sending [auth {}]", (Object)addr, (Object)"*****");
        for (ServerOption serverOption : this.option().serverOptions()) {
            String password = serverOption.password();
            if (password == null) {
                password = this.option().defaultPassword();
            }
            if (!StringUtils.equals(addr, serverOption.addr())) continue;
            EslMessage response = inboundChannelHandler.sendSyncSingleLineCommand("auth " + password);
            this.log.debug("Auth response [{}]", (Object)response);
            if (response.getContentType().equals("command/reply")) {
                CommandResponse reply = new CommandResponse("auth " + password, response);
                serverOption.state(ConnectState.AUTHED);
                this.log.info("Auth response success={}, message=[{}]", (Object)reply.isOk(), (Object)reply.getReplyText());
                if (this.option().events().isEmpty()) continue;
                StringBuilder sb = new StringBuilder();
                for (String event : this.option().events()) {
                    sb.append(event).append(" ");
                }
                this.setEventSubscriptions(addr, "plain", sb.toString());
                continue;
            }
            serverOption.state(ConnectState.AUTHED_FAILED);
            this.log.error("Bad auth response message [{}]", (Object)response);
            throw new IllegalStateException("Incorrect auth response");
        }
    }

    @Override
    public void handleEslEvent(String addr, EslEvent event) {
        this.option().listeners().forEach(listener -> {
            long cost;
            long start = 0L;
            if (this.option().performance()) {
                start = System.currentTimeMillis();
            }
            if (this.option().eventPerformance()) {
                long cost2 = 0L;
                cost2 = start > 0L ? start - event.getEventDateTimestamp() / 1000L : System.currentTimeMillis() - event.getEventDateTimestamp() / 1000L;
                if (cost2 > this.option().eventPerformanceCostTime()) {
                    this.log.warn("[event performance] received esl event diff time : {}ms, event is blocked.", (Object)cost2);
                }
            }
            this.log.debug("Event addr[{}] received [{}]", (Object)addr, (Object)event);
            if (StringUtils.equals(event.getEventName(), "BACKGROUND_JOB")) {
                try {
                    listener.backgroundJobResultReceived(addr, event);
                }
                catch (Throwable t) {
                    this.log.error("Error caught notifying listener of job result [{}], remote address [{}]", new Object[]{event, addr, t});
                }
            } else {
                try {
                    listener.eventReceived(addr, event);
                }
                catch (Throwable t) {
                    this.log.error("Error caught notifying listener of event [{}], remote address [{}]", new Object[]{event, addr, t});
                }
            }
            if (this.option().performance() && (cost = System.currentTimeMillis() - start) >= this.option().performanceCostTime()) {
                this.log.warn("[performance] handle esl event cost time : {}ms", (Object)cost);
            }
        });
    }

    @Override
    public void handleDisconnectNotice(String addr) {
        this.log.info("Disconnected[{}] ...", (Object)addr);
    }

    @Override
    public void handleRudeRejection(String addr) {
        this.log.info("Rejected by acl  ...");
    }

    public InboundChannelHandler getAuthedHandler(String addr) {
        InboundChannelHandler handler = this.handlerTable.get(addr);
        if (handler == null) {
            throw new InboundClientException("not found inbound handler for addr : " + addr);
        }
        List<ServerOption> serverOptions = this.option().serverOptions();
        for (ServerOption serverOption : serverOptions) {
            if (!StringUtils.equals(serverOption.addr(), addr)) continue;
            if (serverOption.state() == ConnectState.AUTHED) break;
            throw new InboundClientException("inbound handler is not authed for addr : " + addr);
        }
        return handler;
    }

    private void addServerOptionListener() {
        this.option().serverOptionListener(new ServerOptionListener(){

            @Override
            public void onAdded(ServerOption serverOption) {
                if (serverOption.state() == ConnectState.INIT) {
                    AbstractInboundClient.this.doConnect(serverOption);
                }
            }

            @Override
            public void onRemoved(ServerOption serverOption) {
                if (serverOption.state() == ConnectState.CONNECTED || serverOption.state() == ConnectState.AUTHED) {
                    AbstractInboundClient.this.doClose(serverOption);
                }
            }
        });
    }

    private void addEventListener() {
        this.log.info("add event listener ...");
        this.option().eventListener(new EventListener(){

            @Override
            public void addEvents(List<String> list) {
                StringBuilder sb = new StringBuilder();
                for (String event : list) {
                    sb.append(event).append(" ");
                }
                AbstractInboundClient.this.option().serverOptions().forEach(serverOption -> AbstractInboundClient.this.publicExecutor.execute(() -> AbstractInboundClient.this.setEventSubscriptions(serverOption.addr(), "plain", sb.toString())));
            }

            @Override
            public void cancelEvents() {
                AbstractInboundClient.this.option().serverOptions().forEach(serverOption -> AbstractInboundClient.this.publicExecutor.execute(() -> AbstractInboundClient.this.cancelEventSubscriptions(serverOption.addr())));
            }
        });
    }

    private void doConnect(ServerOption serverOption) {
        this.log.info("connect remote server [{}:{}] ...", (Object)serverOption.host(), (Object)serverOption.port());
        serverOption.addConnectTimes();
        serverOption.state(ConnectState.CONNECTING);
        this.bootstrap.connect(serverOption.host(), serverOption.port()).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                serverOption.state(ConnectState.CONNECTED);
                this.log.info("connect remote server [{}:{}] success.", (Object)serverOption.host(), (Object)serverOption.port());
            } else {
                serverOption.state(ConnectState.FAILED);
                this.log.warn("connect remote server [{}:{}] failed, will try again, cause : ", new Object[]{serverOption.host(), serverOption.port(), future.cause()});
                this.scheduledPoolExecutor.schedule(() -> this.doConnect(serverOption), (long)this.getTimeoutSeconds(serverOption), TimeUnit.SECONDS);
            }
        }));
    }

    private void doClose(ServerOption serverOption) {
        this.log.info("doClose remote server [{}:{}] success.", (Object)serverOption.host(), (Object)serverOption.port());
        serverOption.state(ConnectState.CLOSING);
        this.option().serverOptions().remove(serverOption);
        String remoteAddr = serverOption.addr();
        InboundChannelHandler inboundChannelHandler = this.handlerTable.get(remoteAddr);
        if (inboundChannelHandler != null) {
            inboundChannelHandler.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    this.log.info("close remote server [{}:{}] success.", (Object)serverOption.host(), (Object)serverOption.port());
                } else {
                    this.log.info("close remote server [{}:{}] failed, cause : ", new Object[]{serverOption.host(), serverOption.port(), future.cause()});
                }
            }));
        }
    }

    private int getTimeoutSeconds(ServerOption serverOption) {
        return serverOption.timeoutSeconds() == 0 ? this.option().defaultTimeoutSeconds() : serverOption.timeoutSeconds();
    }
}

