/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl;

import link.thingscloud.freeswitch.esl.InboundClient;
import link.thingscloud.freeswitch.esl.exception.InboundClientException;
import link.thingscloud.freeswitch.esl.inbound.NettyInboundClient;
import link.thingscloud.freeswitch.esl.inbound.option.InboundClientOption;

class InboundClientFactory {
    private InboundClient inboundClient = null;

    private InboundClientFactory() {
    }

    static InboundClientFactory getInstance() {
        return InboundClientFactoryInstance.INSTANCE;
    }

    synchronized InboundClient newInboundClient(InboundClientOption option) {
        if (this.inboundClient == null) {
            this.inboundClient = new NettyInboundClient(option == null ? new InboundClientOption() : option);
            return this.inboundClient;
        }
        throw new InboundClientException("InboundClient has been created already, instance : [" + this.inboundClient + "]!");
    }

    InboundClient getInboundClient() {
        if (this.inboundClient == null) {
            throw new InboundClientException("InboundClient is null, you must be create it first.");
        }
        return this.inboundClient;
    }

    private static class InboundClientFactoryInstance {
        private static final InboundClientFactory INSTANCE = new InboundClientFactory();

        private InboundClientFactoryInstance() {
        }
    }
}

