/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class StringTools {
    public static String deepTrim(String a_string) {
        return StringTools.deepTrim(a_string, false);
    }

    public static String deepTrimToLower(String a_string) {
        return StringTools.deepTrim(a_string, true);
    }

    public static String deepTrim(String a_string, boolean a_toLowerCase) {
        int ii;
        if (null == a_string) {
            return null;
        }
        StringBuffer l_buf = new StringBuffer();
        for (ii = 0; ii < a_string.length(); ++ii) {
            char ch = a_string.charAt(ii);
            if (Character.isUpperCase(ch) && a_toLowerCase) {
                ch = Character.toLowerCase(ch);
            }
            if (ch == ' ') {
                char l_lastChar;
                if (l_buf.length() - 1 < 0 || (l_lastChar = l_buf.charAt(l_buf.length() - 1)) == ' ') continue;
                l_buf.append(' ');
                continue;
            }
            l_buf.append(ch);
        }
        ii = l_buf.length() - 1;
        if (ii >= 0 && ' ' == l_buf.charAt(ii)) {
            l_buf.deleteCharAt(ii);
        }
        return l_buf.toString();
    }

    public static String centerTrunc(String a_str, int a_head, int a_tail) {
        StringBuffer l_buf = null;
        if (a_str.length() <= a_head + a_tail + 7 + a_str.length() / 10) {
            return a_str;
        }
        l_buf = new StringBuffer();
        l_buf.append('[').append(a_str.length()).append("][");
        l_buf.append(a_str.substring(0, a_head)).append("...");
        l_buf.append(a_str.substring(a_str.length() - a_tail));
        l_buf.append(']');
        return l_buf.toString();
    }

    public static String toHexString(byte[] a_res) {
        StringBuffer l_buf = new StringBuffer(a_res.length << 1);
        for (int ii = 0; ii < a_res.length; ++ii) {
            String l_digit = Integer.toHexString(0xFF & a_res[ii]);
            if (l_digit.length() == 1) {
                l_digit = '0' + l_digit;
            }
            l_buf.append(l_digit);
        }
        return l_buf.toString().toUpperCase();
    }

    public static byte[] toByteArray(String a_hexString) {
        int l_arrLength = a_hexString.length() >> 1;
        byte[] l_buf = new byte[l_arrLength];
        for (int ii = 0; ii < l_arrLength; ++ii) {
            int l_index = ii << 1;
            String l_digit = a_hexString.substring(l_index, l_index + 2);
            l_buf[ii] = (byte)Integer.parseInt(l_digit, 16);
        }
        return l_buf;
    }

    public static String formatHtml(String a_source, boolean a_bReplaceNl, boolean a_bReplaceTag, boolean a_bReplaceQuote) {
        StringBuffer l_buf = new StringBuffer();
        int l_len = a_source.length();
        block8: for (int ii = 0; ii < l_len; ++ii) {
            char ch = a_source.charAt(ii);
            switch (ch) {
                case '\"': {
                    if (a_bReplaceQuote) {
                        l_buf.append("&quot;");
                        continue block8;
                    }
                    l_buf.append(ch);
                    continue block8;
                }
                case '<': {
                    if (a_bReplaceTag) {
                        l_buf.append("&lt;");
                        continue block8;
                    }
                    l_buf.append(ch);
                    continue block8;
                }
                case '>': {
                    if (a_bReplaceTag) {
                        l_buf.append("&gt;");
                        continue block8;
                    }
                    l_buf.append(ch);
                    continue block8;
                }
                case '\n': {
                    if (a_bReplaceNl) {
                        if (a_bReplaceTag) {
                            l_buf.append("&lt;br&gt;");
                            continue block8;
                        }
                        l_buf.append("<br>");
                        continue block8;
                    }
                    l_buf.append(ch);
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                case '&': {
                    l_buf.append("&amp;");
                    continue block8;
                }
                default: {
                    l_buf.append(ch);
                }
            }
        }
        return l_buf.toString();
    }

    public static RE getRegex(String a_initial, String[] a_any, String a_final) throws RESyntaxException {
        StringBuffer l_buf = new StringBuffer();
        if (a_initial != null) {
            l_buf.append('^').append(a_initial);
        }
        if (a_any != null) {
            for (int ii = 0; ii < a_any.length; ++ii) {
                l_buf.append(".*").append(a_any[ii]);
            }
        }
        if (a_final != null) {
            l_buf.append(".*").append(a_final);
        }
        return new RE(l_buf.toString());
    }

    public static RE getRegex(String a_ldapRegex) throws RESyntaxException {
        if (a_ldapRegex == null) {
            throw new RESyntaxException("Regex was null");
        }
        ArrayList<String> l_any = new ArrayList<String>();
        String l_remaining = a_ldapRegex;
        int l_index = l_remaining.indexOf(42);
        if (l_index == -1) {
            throw new RESyntaxException("Ldap regex must have wild cards!");
        }
        String l_initial = null;
        if (l_remaining.charAt(0) != '*') {
            l_initial = l_remaining.substring(0, l_index);
        }
        l_remaining = l_remaining.substring(l_index + 1, l_remaining.length());
        while ((l_index = l_remaining.indexOf(42)) != -1) {
            l_any.add(l_remaining.substring(0, l_index));
            l_remaining = l_remaining.substring(l_index + 1, l_remaining.length());
        }
        String l_final = null;
        if (!l_remaining.endsWith("*") && l_remaining.length() > 0) {
            l_final = l_remaining;
        }
        if (l_any.size() > 0) {
            String[] l_anyStrs = new String[l_any.size()];
            for (int ii = 0; ii < l_anyStrs.length; ++ii) {
                l_anyStrs[ii] = (String)l_any.get(ii);
            }
            return StringTools.getRegex(l_initial, l_anyStrs, l_final);
        }
        return StringTools.getRegex(l_initial, null, l_final);
    }

    public static List getPaths(String a_paths, FileFilter a_filter) {
        int l_max = a_paths.length() - 1;
        int l_start = 0;
        int l_stop = -1;
        String l_path = null;
        ArrayList<String> l_list = new ArrayList<String>();
        if (a_paths == null || a_paths.trim().equals("")) {
            return l_list;
        }
        while (l_start < l_max) {
            l_stop = a_paths.indexOf(File.pathSeparatorChar, l_start);
            if (l_stop == -1) {
                if (l_start >= l_max || (l_path = a_paths.substring(l_start)).trim().equals("") || a_filter != null && !a_filter.accept(new File(l_path))) break;
                l_list.add(l_path);
                break;
            }
            l_path = a_paths.substring(l_start, l_stop);
            if (!l_path.trim().equals("") && (a_filter == null || a_filter.accept(new File(l_path)))) {
                l_list.add(l_path);
            }
            l_start = l_stop + 1;
        }
        return l_list;
    }
}

