/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.name;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.ldap.common.name.DnParser;

public class LdapName
implements Name {
    private static DnParser s_parser = null;
    private List m_list;
    private String m_name;
    private boolean m_isClean = false;

    public LdapName() {
        this.m_list = new ArrayList();
    }

    public LdapName(String a_dn) throws NamingException {
        if (null == a_dn || a_dn.trim().equals("")) {
            this.m_list = new ArrayList();
            return;
        }
        LdapName.getNameParser().parse(a_dn, this);
    }

    LdapName(List a_list) {
        this.m_list = a_list;
    }

    LdapName(Iterator a_list) {
        this.m_list = new ArrayList();
        while (a_list.hasNext()) {
            this.m_list.add(a_list.next());
        }
    }

    void setList(ArrayList a_list) {
        this.m_list = a_list;
    }

    public Object clone() {
        return new LdapName(this.m_list.iterator());
    }

    public int compareTo(Object an_obj) {
        if (an_obj instanceof LdapName) {
            LdapName l_dn = (LdapName)an_obj;
            int l_min = Math.min(this.size(), l_dn.size());
            for (int ii = 0; ii < l_min; ++ii) {
                int l_comparison = this.get(ii).compareTo(l_dn.get(ii));
                if (l_comparison == 0) continue;
                return l_comparison;
            }
            if (this.m_list.size() == l_dn.size()) {
                return 0;
            }
            if (this.m_list.size() > l_dn.size()) {
                return 1;
            }
            return -1;
        }
        throw new ClassCastException("The object to compare this LdapName to is not a valid LDAP distinguished name.");
    }

    public int size() {
        return this.m_list.size();
    }

    public boolean isEmpty() {
        return this.m_list.isEmpty();
    }

    public Enumeration getAll() {
        return new Enumeration(){
            private int l_pos;

            public boolean hasMoreElements() {
                return this.l_pos < LdapName.this.size();
            }

            public Object nextElement() {
                if (this.l_pos >= LdapName.this.size()) {
                    throw new NoSuchElementException();
                }
                String l_obj = LdapName.this.get(this.l_pos);
                ++this.l_pos;
                return l_obj;
            }
        };
    }

    public String get(int a_posn) {
        return (String)this.m_list.get(this.size() - a_posn - 1);
    }

    public Name getPrefix(int a_posn) {
        return new LdapName(this.m_list.subList(this.size() - a_posn, this.size()));
    }

    public Name getSuffix(int a_posn) {
        return new LdapName(this.m_list.subList(a_posn, this.m_list.size()));
    }

    public boolean startsWith(Name a_name) {
        if (a_name instanceof LdapName) {
            LdapName l_dn = (LdapName)a_name;
            if (l_dn.size() > this.size()) {
                return false;
            }
            for (int ii = 0; ii < l_dn.size(); ++ii) {
                if (l_dn.get(ii).equals(this.get(ii))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean endsWith(Name a_name) {
        if (a_name instanceof LdapName) {
            LdapName l_dn = (LdapName)a_name;
            if (l_dn.size() > this.size()) {
                return false;
            }
            int l_difference = this.size() - l_dn.size();
            for (int ii = 0; ii < l_dn.size(); ++ii) {
                if (l_dn.get(ii).equals(this.get(l_difference + ii))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void syntaxCheck(String a_component) throws InvalidNameException {
        if (a_component.indexOf(61) == -1) {
            throw new InvalidNameException("Name component " + a_component + " is not a valid distinguished name component.");
        }
    }

    private void syntaxCheck(String a_component, int a_index) throws InvalidNameException {
        if (a_component.indexOf(61) == -1) {
            throw new InvalidNameException("Name component " + a_component + " at index " + a_index + " is not a valid distinguished name component.");
        }
    }

    public Name addAll(Name a_suffix) throws InvalidNameException {
        int ii;
        for (ii = 0; ii < a_suffix.size(); ++ii) {
            this.syntaxCheck(a_suffix.get(ii), ii);
        }
        for (ii = 0; ii < a_suffix.size(); ++ii) {
            this.m_list.add(0, a_suffix.get(ii));
        }
        this.m_isClean = false;
        return this;
    }

    public Name addAll(int a_posn, Name a_name) throws InvalidNameException {
        int ii;
        for (ii = 0; ii < a_name.size(); ++ii) {
            this.syntaxCheck(a_name.get(ii), ii);
        }
        for (ii = 0; ii < a_name.size(); ++ii) {
            this.m_list.add(this.size() - a_posn - ii, a_name.get(ii));
        }
        this.m_isClean = false;
        return this;
    }

    public Name add(String a_comp) throws InvalidNameException {
        this.syntaxCheck(a_comp);
        this.m_list.add(0, a_comp);
        this.m_isClean = false;
        return this;
    }

    public Name add(int a_posn, String a_comp) throws InvalidNameException {
        this.syntaxCheck(a_comp);
        this.m_list.add(this.size() - a_posn, a_comp);
        this.m_isClean = false;
        return this;
    }

    public Object remove(int a_posn) throws InvalidNameException {
        this.m_isClean = false;
        return this.m_list.remove(this.size() - a_posn - 1);
    }

    public String toString() {
        if (this.m_name != null && this.m_isClean) {
            return this.m_name;
        }
        if (this.m_list.size() == 0) {
            this.m_name = "";
            return this.m_name;
        }
        StringBuffer l_dnStr = new StringBuffer((String)this.m_list.get(0));
        for (int ii = 1; ii < this.m_list.size(); ++ii) {
            l_dnStr.append(',').append(this.m_list.get(ii));
        }
        this.m_name = l_dnStr.toString();
        this.m_isClean = true;
        return this.m_name;
    }

    public boolean equals(Object an_obj) {
        if (an_obj instanceof String) {
            return this.toString().equals(an_obj);
        }
        if (an_obj instanceof Name) {
            Name l_name = (Name)an_obj;
            if (l_name.size() != this.size()) {
                return false;
            }
            for (int ii = 0; ii < this.size(); ++ii) {
                if (l_name.get(ii).equals(this.get(ii))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static DnParser getNameParser() throws NamingException {
        if (s_parser == null) {
            try {
                s_parser = new DnParser();
            }
            catch (IOException ioe) {
                NamingException l_ne = new NamingException("Could not instantiate name parser for LdapName");
                l_ne.setRootCause(ioe);
                throw l_ne;
            }
        }
        return s_parser;
    }

    public String getRdn() {
        if (0 == this.size()) {
            return "";
        }
        return this.get(this.size() - 1);
    }

    public static String getRdn(Name a_dn) {
        if (0 == a_dn.size()) {
            return "";
        }
        return a_dn.get(a_dn.size() - 1);
    }
}

