/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.spi.DecoderSpi;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.TransformerSpi;

public final class MessageDecoder {
    private final Properties m_env;
    private final Provider m_provider;
    private final DecoderSpi m_decoder;
    private final TransformerSpi m_transformer;

    public MessageDecoder() throws MessageException {
        this(Provider.getEnvironment());
    }

    public MessageDecoder(Properties a_env) throws MessageException {
        this.m_env = (Properties)((Hashtable)a_env).clone();
        this.m_provider = Provider.getProvider(this.m_env);
        this.m_decoder = this.m_provider.getDecoder();
        this.m_transformer = this.m_provider.getTransformer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message decode(Object a_lock, InputStream a_in) throws MessageException {
        Object l_providerEnvelope = null;
        if (a_lock == null) {
            l_providerEnvelope = this.m_decoder.decode(a_lock, a_in);
        } else {
            Object object = a_lock;
            synchronized (object) {
                l_providerEnvelope = this.m_decoder.decode(a_lock, a_in);
                a_lock.notifyAll();
            }
        }
        Message l_message = this.m_transformer.transform(l_providerEnvelope);
        l_message.setLocked(true);
        return l_message;
    }
}

