/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.FilterParser;
import org.apache.ldap.common.filter.FilterParserMonitor;
import org.apache.ldap.common.filter.FilterParserMonitorAdapter;
import org.apache.ldap.common.filter.antlrFilterLexer;
import org.apache.ldap.common.filter.antlrFilterParser;

public class FilterParserImpl
implements FilterParser {
    private FilterParserMonitor monitor = new FilterParserMonitorAdapter();
    private antlrFilterParser m_parser = null;
    private PipedOutputStream m_parserIn = null;

    public FilterParserImpl() throws IOException {
        this.init();
    }

    public void init() throws IOException {
        this.m_parserIn = new PipedOutputStream();
        PipedInputStream l_in = new PipedInputStream();
        this.m_parserIn.connect(l_in);
        antlrFilterLexer l_lexer = new antlrFilterLexer(l_in);
        this.m_parser = new antlrFilterParser(l_lexer);
    }

    public synchronized ExprNode parse(String a_filter) throws IOException, ParseException {
        ExprNode l_root = null;
        if (a_filter == null || a_filter.trim().equals("")) {
            throw new ParseException("The filter string is either null or is the empty String!", 0);
        }
        if (null == this.monitor) {
            this.monitor = new FilterParserMonitorAdapter();
        }
        this.m_parserIn.write(a_filter.getBytes());
        this.m_parserIn.write(10);
        this.m_parserIn.flush();
        try {
            l_root = this.m_parser.filter();
        }
        catch (RecognitionException e) {
            String l_msg = "Parser failure on filter:\n\t" + a_filter;
            l_msg = l_msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace((Throwable)e);
            this.init();
            throw new ParseException(l_msg, e.getColumn());
        }
        catch (TokenStreamException e2) {
            String l_msg = "Parser failure on filter:\n\t" + a_filter;
            l_msg = l_msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace((Throwable)e2);
            this.init();
            throw new ParseException(l_msg, 0);
        }
        return l_root;
    }

    public void setFilterParserMonitor(FilterParserMonitor monitor) {
        this.monitor = monitor;
    }
}

