/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profiler.threadcheck;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;

public final class StartupProfilerCheck
implements Runnable {
    public static final int COMMAND_START = 1;
    public static final int COMMAND_PAUSE = 2;
    public static final int COMMAND_STOP = 3;
    private String endereco;
    int porta;
    long pid;
    private static final int STOPPED = 0;
    private static final int RUNNING = 1;
    private static final int PAUSED = 2;
    private static final int DETTACHED = 3;
    static int profilerState;

    private StartupProfilerCheck(String endereco, int porta, long pid) {
        this.endereco = endereco;
        this.porta = porta;
        this.pid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Socket socket = new Socket(this.endereco, this.porta);
            OutputStream out = socket.getOutputStream();
            PrintStream printStream = new PrintStream(out);
            printStream.println(this.pid);
            out.flush();
            InputStream inp = socket.getInputStream();
            while (true) {
                int command = inp.read();
                try {
                    if (command == 1) {
                        StartupProfilerCheck.startProfiler();
                        continue;
                    }
                    if (command == 3) {
                        StartupProfilerCheck.stopProfiler();
                        break;
                    }
                    if (command != 2) continue;
                    StartupProfilerCheck.pauseProfiler();
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
        }
        catch (Exception e) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("Error in Profiller Startup Checker");
                e.printStackTrace();
            }
        }
    }

    public static void initCheck(String paramEndereco, long pid) {
        int doisPontos = paramEndereco.indexOf(58);
        if (doisPontos < 0) {
            System.err.println("Error: Invalid Addres " + paramEndereco);
            System.err.println("Valid format is <IP>:<PORT>");
            return;
        }
        String endereco = paramEndereco.substring(0, doisPontos);
        String porta = paramEndereco.substring(doisPontos + 1);
        System.out.println("endereco = " + endereco);
        System.out.println("porta = " + porta);
        Thread thread = new Thread(new StartupProfilerCheck(endereco, Integer.parseInt(porta), pid));
        thread.start();
    }

    public static void startProfiler() {
        if (profilerState == 3) {
            throw new RuntimeException("Can't start profiler - dettached state");
        }
        if (profilerState != 1) {
            StartupProfilerCheck.startProfilerInternal();
            profilerState = 1;
        }
    }

    public static void stopProfiler() {
        if (profilerState == 3) {
            throw new RuntimeException("Can't start profiler - dettached state");
        }
        if (profilerState != 0) {
            StartupProfilerCheck.stopProfilerInternal();
            profilerState = 0;
        }
    }

    public static void pauseProfiler() {
        if (profilerState != 3) {
            StartupProfilerCheck.pauseProfilerInternal();
            profilerState = 2;
        }
    }

    private static native void startProfilerInternal();

    private static native void pauseProfilerInternal();

    private static native void stopProfilerInternal();

    static {
        System.loadLibrary("jbossInspector");
        profilerState = 0;
    }
}

