/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profiler.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.jboss.profiler.console.ProfilerControl;

public class ProfilerPID {
    ProfilerControl control;
    Socket socket;
    long pid;
    String activeCommand = "stop";
    InputStream inp = null;
    OutputStream out = null;

    public ProfilerPID(Socket socket, ProfilerControl control) throws IOException {
        this.socket = socket;
        this.control = control;
        this.inp = socket.getInputStream();
        this.out = socket.getOutputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.inp));
        String pidSTR = reader.readLine();
        try {
            this.pid = Long.parseLong(pidSTR);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void executeCommand(String commandStr, int commandNumber) {
        String oldCommandStr = this.activeCommand;
        try {
            this.out.write(commandNumber);
            this.activeCommand = commandStr;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.activeCommand = oldCommandStr;
        }
    }

    public long getPid() {
        return this.pid;
    }

    public String getActiveCommand() {
        return this.activeCommand;
    }
}

