/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.delegate;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.jms.JMSException;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.container.JMSClientVMIdentifier;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.delegate.TopologyResult;
import org.jboss.jms.exception.MessagingNetworkFailureException;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateRequest;
import org.jboss.jms.wireformat.ConnectionFactoryGetClientAOPStackRequest;
import org.jboss.jms.wireformat.JMSWireFormat;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.messaging.util.Version;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;

public class ClientConnectionFactoryDelegate
extends DelegateSupport
implements ConnectionFactoryDelegate,
Serializable,
Advised {
    private static final long serialVersionUID = 2512460695662741413L;
    private String uniqueName;
    private String serverLocatorURI;
    private Version serverVersion;
    private int serverID;
    private boolean clientPing;
    private boolean strictTck;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_createConnectionDelegate_N_3019492359065420858;
    private static WeakReference aop$MethodInfo_getClientAOPStack7161396531404689859;
    private static WeakReference aop$MethodInfo_getTopology7611120934159013485;

    public static Version getVersionToUse(Version connectionVersion) {
        Version clientVersion = Version.instance();
        Version versionToUse = connectionVersion.getProviderIncrementingVersion() <= clientVersion.getProviderIncrementingVersion() ? connectionVersion : clientVersion;
        return versionToUse;
    }

    public ClientConnectionFactoryDelegate(String uniqueName, String objectID, int serverID, String serverLocatorURI, Version serverVersion, boolean clientPing, boolean strictTck) {
        super(objectID);
        this.uniqueName = uniqueName;
        this.serverID = serverID;
        this.serverLocatorURI = serverLocatorURI;
        this.serverVersion = serverVersion;
        this.clientPing = clientPing;
        this.strictTck = strictTck;
    }

    public ClientConnectionFactoryDelegate() {
    }

    public CreateConnectionResult org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(String username, String password, int failedNodeID) throws JMSException {
        CreateConnectionResult res;
        Version version = ClientConnectionFactoryDelegate.getVersionToUse(this.serverVersion);
        byte v = version.getProviderIncrementingVersion();
        JMSRemotingConnection remotingConnection = null;
        try {
            remotingConnection = new JMSRemotingConnection(this.serverLocatorURI, this.clientPing, this.strictTck);
            remotingConnection.start();
            Client client = remotingConnection.getRemotingClient();
            String remotingSessionId = client.getSessionId();
            String clientVMId = JMSClientVMIdentifier.instance;
            ConnectionFactoryCreateConnectionDelegateRequest req = new ConnectionFactoryCreateConnectionDelegateRequest(this.id, v, remotingSessionId, clientVMId, username, password, failedNodeID);
            ResponseSupport rs = (ResponseSupport)client.invoke((Object)req, null);
            res = (CreateConnectionResult)rs.getResponse();
        }
        catch (Throwable t) {
            if (remotingConnection != null) {
                try {
                    remotingConnection.stop();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            throw this.handleThrowable(t);
        }
        ClientConnectionDelegate connectionDelegate = res.getDelegate();
        if (connectionDelegate != null) {
            connectionDelegate.setRemotingConnection(remotingConnection);
            connectionDelegate.setVersionToUse(version);
        } else {
            try {
                remotingConnection.stop();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return res;
    }

    public byte[] org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop() throws JMSException {
        Version version = ClientConnectionFactoryDelegate.getVersionToUse(this.serverVersion);
        byte v = version.getProviderIncrementingVersion();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("enableLease", String.valueOf(false));
        Client theClient = this.createClient();
        ConnectionFactoryGetClientAOPStackRequest req = new ConnectionFactoryGetClientAOPStackRequest(this.id, v);
        return (byte[])this.doInvoke(theClient, req);
    }

    public TopologyResult org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getTopology$aop() throws JMSException {
        throw new IllegalStateException("This invocation should not be handled here!");
    }

    public String toString() {
        return "ConnectionFactoryDelegate[" + this.id + ", SID=" + this.serverID + "]";
    }

    public String getServerLocatorURI() {
        return this.serverLocatorURI;
    }

    public int getServerID() {
        return this.serverID;
    }

    public boolean getClientPing() {
        return this.clientPing;
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public boolean getStrictTck() {
        return this.strictTck;
    }

    public void synchronizeWith(DelegateSupport newDelegate) throws Exception {
        super.synchronizeWith(newDelegate);
    }

    private Client createClient() throws JMSException {
        Client client;
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("enableLease", String.valueOf(false));
        try {
            client = new Client(new InvokerLocator(this.serverLocatorURI), configuration);
            client.setSubsystem("JMS");
            client.connect();
        }
        catch (Exception e) {
            throw new MessagingNetworkFailureException("Failed to connect client", e);
        }
        client.setMarshaller((Marshaller)new JMSWireFormat());
        client.setUnMarshaller((UnMarshaller)new JMSWireFormat());
        return client;
    }

    public void read(DataInputStream in) throws Exception {
        super.read(in);
        this.serverLocatorURI = in.readUTF();
        this.serverVersion = new Version();
        this.serverVersion.read(in);
        this.serverID = in.readInt();
        this.clientPing = in.readBoolean();
        this.strictTck = in.readBoolean();
    }

    public void write(DataOutputStream out) throws Exception {
        super.write(out);
        out.writeUTF(this.serverLocatorURI);
        this.serverVersion.write(out);
        out.writeInt(this.serverID);
        out.writeBoolean(this.clientPing);
        out.writeBoolean(this.strictTck);
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        ClientConnectionFactoryDelegate clientConnectionFactoryDelegate = this;
        synchronized (clientConnectionFactoryDelegate) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        ClientConnectionFactoryDelegate clientConnectionFactoryDelegate = this;
        synchronized (clientConnectionFactoryDelegate) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    public CreateConnectionResult createConnectionDelegate(String string, String string2, int n) throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createConnectionDelegate_N_3019492359065420858.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createConnectionDelegate_N3019492359065420858 createConnectionDelegate_N30194923590654208582 = new createConnectionDelegate_N3019492359065420858(methodInfo, interceptorArray);
            createConnectionDelegate_N30194923590654208582.arg0 = string;
            createConnectionDelegate_N30194923590654208582.arg1 = string2;
            createConnectionDelegate_N30194923590654208582.arg2 = n;
            createConnectionDelegate_N30194923590654208582.setTargetObject(this);
            createConnectionDelegate_N30194923590654208582.typedTargetObject = this;
            createConnectionDelegate_N30194923590654208582.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (CreateConnectionResult)createConnectionDelegate_N30194923590654208582.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(string, string2, n);
    }

    public byte[] getClientAOPStack() throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getClientAOPStack7161396531404689859.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getClientAOPStack_7161396531404689859 getClientAOPStack_71613965314046898592 = new getClientAOPStack_7161396531404689859(methodInfo, interceptorArray);
            getClientAOPStack_71613965314046898592.setTargetObject(this);
            getClientAOPStack_71613965314046898592.typedTargetObject = this;
            getClientAOPStack_71613965314046898592.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (byte[])getClientAOPStack_71613965314046898592.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop();
    }

    public TopologyResult getTopology() throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getTopology7611120934159013485.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getTopology_7611120934159013485 getTopology_76111209341590134852 = new getTopology_7611120934159013485(methodInfo, interceptorArray);
            getTopology_76111209341590134852.setTargetObject(this);
            getTopology_76111209341590134852.typedTargetObject = this;
            getTopology_76111209341590134852.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (TopologyResult)getTopology_76111209341590134852.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getTopology$aop();
    }

    public static class createConnectionDelegate_N3019492359065420858
    extends MethodInvocation
    implements Untransformable {
        boolean inconsistentArgs = false;
        public String arg0;
        public String arg1;
        public int arg2;
        public ClientConnectionFactoryDelegate typedTargetObject;

        public createConnectionDelegate_N3019492359065420858(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createConnectionDelegate_N3019492359065420858(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createConnectionDelegate_N3019492359065420858(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createConnectionDelegate_N3019492359065420858() {
        }

        public Object[] getArguments() {
            this.inconsistentArgs = true;
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Integer(this.arg2);
            return this.arguments;
        }

        public void setArguments(Object[] objectArray) {
            this.inconsistentArgs = true;
            this.arguments = objectArray;
        }

        final void enforceArgsConsistency() {
            if (this.inconsistentArgs) {
                this.arg0 = (String)this.arguments[0];
                this.arg1 = (String)this.arguments[1];
                this.arg2 = (Integer)this.arguments[2];
            }
        }

        public Object invokeTarget() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(this.arg0, this.arg1, this.arg2);
        }

        public Invocation copy() {
            createConnectionDelegate_N3019492359065420858 createConnectionDelegate_N30194923590654208582 = new createConnectionDelegate_N3019492359065420858(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createConnectionDelegate_N30194923590654208582.arguments = this.arguments;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).instanceResolver = ((InvocationBase)this).instanceResolver;
            createConnectionDelegate_N30194923590654208582.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).targetObject = ((InvocationBase)this).targetObject;
            createConnectionDelegate_N30194923590654208582.arg0 = this.arg0;
            createConnectionDelegate_N30194923590654208582.arg1 = this.arg1;
            createConnectionDelegate_N30194923590654208582.arg2 = this.arg2;
            return createConnectionDelegate_N30194923590654208582;
        }
    }

    public static class getClientAOPStack_7161396531404689859
    extends MethodInvocation
    implements Untransformable {
        public ClientConnectionFactoryDelegate typedTargetObject;

        public getClientAOPStack_7161396531404689859(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getClientAOPStack_7161396531404689859(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getClientAOPStack_7161396531404689859(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getClientAOPStack_7161396531404689859() {
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        public Object invokeTarget() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop();
        }

        public Invocation copy() {
            getClientAOPStack_7161396531404689859 getClientAOPStack_71613965314046898592 = new getClientAOPStack_7161396531404689859(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getClientAOPStack_71613965314046898592.arguments = this.arguments;
            ((InvocationBase)getClientAOPStack_71613965314046898592).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getClientAOPStack_71613965314046898592).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getClientAOPStack_71613965314046898592).instanceResolver = ((InvocationBase)this).instanceResolver;
            getClientAOPStack_71613965314046898592.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getClientAOPStack_71613965314046898592).targetObject = ((InvocationBase)this).targetObject;
            return getClientAOPStack_71613965314046898592;
        }
    }

    public static class getTopology_7611120934159013485
    extends MethodInvocation
    implements Untransformable {
        public ClientConnectionFactoryDelegate typedTargetObject;

        public getTopology_7611120934159013485(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getTopology_7611120934159013485(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getTopology_7611120934159013485(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getTopology_7611120934159013485() {
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        public Object invokeTarget() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getTopology$aop();
        }

        public Invocation copy() {
            getTopology_7611120934159013485 getTopology_76111209341590134852 = new getTopology_7611120934159013485(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getTopology_76111209341590134852.arguments = this.arguments;
            ((InvocationBase)getTopology_76111209341590134852).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getTopology_76111209341590134852).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getTopology_76111209341590134852).instanceResolver = ((InvocationBase)this).instanceResolver;
            getTopology_76111209341590134852.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getTopology_76111209341590134852).targetObject = ((InvocationBase)this).targetObject;
            return getTopology_76111209341590134852;
        }
    }
}

