/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class SAAJUtils {
    public static void setQualifiedElementValue(SOAPElement element, QName value) throws SOAPException {
        String prefix = SAAJUtils.ensureNamespaceDeclared(element, value.getPrefix(), value.getNamespaceURI());
        element.setValue(prefix + ':' + value.getLocalPart());
    }

    public static void setQualifiedAttributeValue(SOAPElement element, String attributeName, QName value) throws SOAPException {
        String prefix = SAAJUtils.ensureNamespaceDeclared(element, value.getPrefix(), value.getNamespaceURI());
        element.setAttribute(attributeName, prefix + ':' + value.getLocalPart());
    }

    private static String ensureNamespaceDeclared(SOAPElement element, String prefix, String nsURI) throws SOAPException {
        if (prefix.length() == 0) {
            prefix = SAAJUtils.getNamespacePrefix(element, nsURI);
            if (prefix == null) {
                prefix = "valueNS";
                element.addNamespaceDeclaration(prefix, nsURI);
            }
        } else if (!nsURI.equals(element.getNamespaceURI(prefix))) {
            element.addNamespaceDeclaration(prefix, nsURI);
        }
        return prefix;
    }

    public static String getNamespacePrefix(SOAPElement element, String nsURI) {
        Iterator it = element.getVisibleNamespacePrefixes();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            if (!nsURI.equals(element.getNamespaceURI(prefix))) continue;
            return prefix;
        }
        return null;
    }
}

