/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.wsf.container.jboss50.WebXMLRewriterImpl;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class WebAppDeploymentAspect
extends DeploymentAspect {
    private static Logger log = Logger.getLogger(WebAppDeploymentAspect.class);
    private DeployerClient mainDeployer;
    private WebXMLRewriterImpl webXMLRewriter;
    private Map<String, Deployment> deploymentMap = new HashMap<String, Deployment>();

    public void setMainDeployer(DeployerClient mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void setWebXMLRewriter(WebXMLRewriterImpl serviceEndpointPublisher) {
        this.webXMLRewriter = serviceEndpointPublisher;
    }

    public void create(org.jboss.wsf.spi.deployment.Deployment dep) {
        URL warURL = (URL)dep.getProperty("org.jboss.ws.webapp.url");
        if (warURL == null) {
            throw new IllegalStateException("Cannot obtain generated webapp URL");
        }
        log.debug((Object)("publishServiceEndpoint: " + warURL));
        try {
            this.webXMLRewriter.rewriteWebXml(dep);
            Deployment deployment = this.createDeploymentContext(warURL);
            this.mainDeployer.deploy(deployment);
            this.deploymentMap.put(warURL.toExternalForm(), deployment);
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    public void destroy(org.jboss.wsf.spi.deployment.Deployment dep) {
        URL warURL = (URL)dep.getProperty("org.jboss.ws.webapp.url");
        if (warURL == null) {
            log.error((Object)"Cannot obtain generated webapp URL");
            return;
        }
        log.debug((Object)("destroyServiceEndpoint: " + warURL));
        try {
            Deployment deployment = this.deploymentMap.get(warURL.toExternalForm());
            if (deployment != null) {
                this.mainDeployer.undeploy(deployment);
                this.deploymentMap.remove(warURL.toExternalForm());
            }
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private Deployment createDeploymentContext(URL warURL) throws Exception {
        VirtualFile file = VFS.getRoot((URL)warURL);
        return VFSDeploymentFactory.getInstance().createVFSDeployment(file);
    }
}

