/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.Map;
import javax.servlet.Servlet;
import org.jboss.metadata.Listener;
import org.jboss.metadata.NameValuePair;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.web.ParamValue;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyWebMetaDataDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment dep) {
        Map contextParams;
        String propKey = "org.jboss.ws.webapp.ServletClass";
        String servletClass = (String)dep.getProperty(propKey);
        if (servletClass == null) {
            throw new IllegalStateException("Cannot obtain context property: " + propKey);
        }
        this.modifyServletClass(dep, servletClass);
        propKey = "org.jboss.ws.webapp.ServletContextListener";
        String listenerClass = (String)dep.getProperty(propKey);
        if (listenerClass != null) {
            this.modifyListener(dep, listenerClass);
        }
        if ((contextParams = (Map)dep.getProperty(propKey = "org.jboss.ws.webapp.ContextParameterMap")) != null) {
            this.modifyContextParams(dep, contextParams);
        }
    }

    private void modifyServletClass(Deployment dep, String servletClass) {
        WebMetaData webMetaData = (WebMetaData)dep.getAttachment(WebMetaData.class);
        if (webMetaData != null) {
            for (org.jboss.metadata.web.Servlet servlet : webMetaData.getServlets()) {
                String orgServletClass = servlet.getServletClass();
                if (orgServletClass == null || orgServletClass.length() == 0) {
                    this.log.debug((Object)("Innore servlet class: " + orgServletClass));
                    continue;
                }
                if (this.isAlreadyModified(servlet) || this.isJavaxServlet(orgServletClass, dep.getInitialClassLoader())) continue;
                servlet.setServletClass(servletClass);
                NameValuePair initParam = new NameValuePair("jboss.ws.endpoint", orgServletClass);
                servlet.addInitParam(initParam);
            }
        }
    }

    private void modifyListener(Deployment dep, String listenerClass) {
        WebMetaData webMetaData = (WebMetaData)dep.getAttachment(WebMetaData.class);
        if (webMetaData != null) {
            Listener listener = new Listener();
            listener.setListenerClass(listenerClass);
            webMetaData.addListener(listener);
        }
    }

    private void modifyContextParams(Deployment dep, Map<String, String> contextParams) {
        WebMetaData webMetaData = (WebMetaData)dep.getAttachment(WebMetaData.class);
        if (webMetaData != null) {
            for (Map.Entry<String, String> entry : contextParams.entrySet()) {
                ParamValue ctxParam = new ParamValue();
                ctxParam.setType(ParamValue.ParamType.CONTEXT_PARAM);
                ctxParam.setName(entry.getKey());
                ctxParam.setValue(entry.getValue());
                webMetaData.addContextParam(ctxParam);
            }
        }
    }

    private boolean isJavaxServlet(String orgServletClass, ClassLoader loader) {
        boolean isServlet = false;
        if (loader != null) {
            try {
                Class<?> servletClass = loader.loadClass(orgServletClass);
                isServlet = Servlet.class.isAssignableFrom(servletClass);
                if (isServlet) {
                    this.log.info((Object)("Ignore servlet: " + orgServletClass));
                }
            }
            catch (ClassNotFoundException e) {
                this.log.warn((Object)("Cannot load servlet class: " + orgServletClass));
            }
        }
        return isServlet;
    }

    private boolean isAlreadyModified(org.jboss.metadata.web.Servlet servlet) {
        for (NameValuePair pair : servlet.getInitParams()) {
            if (!"jboss.ws.endpoint".equals(pair.getName())) continue;
            return true;
        }
        return false;
    }
}

